/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.teamacronymcoders.base.util.Platform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class ItemStackUtils {
    private ItemStackUtils() {
    }

    public static boolean isSmeltable(ItemStack itemStack) {
        return ItemStackUtils.isValid(itemStack) && ItemStackUtils.isValid(FurnaceRecipes.func_77602_a().func_151395_a(itemStack));
    }

    public static boolean isItemInstanceOf(ItemStack itemStack, @Nonnull Class itemClass) {
        return ItemStackUtils.isValid(itemStack) && itemClass.isInstance(itemStack.func_77973_b());
    }

    public static boolean doItemsMatch(ItemStack itemStack, Item item) {
        return ItemStackUtils.isValid(itemStack) && itemStack.func_77973_b() == item;
    }

    public static boolean isValid(@Nullable ItemStack itemStack) {
        return itemStack != null && !itemStack.func_190926_b();
    }

    public static ItemStack getItemStackFromBlockState(IBlockState blockState) {
        Item item = Item.func_150898_a((Block)blockState.func_177230_c());
        ItemStack itemStack = ItemStack.field_190927_a;
        if (item != Items.field_190931_a) {
            itemStack = new ItemStack(item, 1, blockState.func_177230_c().func_176201_c(blockState));
        }
        return itemStack;
    }

    public static boolean isPlayerCarrying(Item item, EntityPlayer player) {
        return ItemStackUtils.doItemsMatch(player.func_184614_ca(), item) || ItemStackUtils.doItemsMatch(player.func_184592_cb(), item);
    }

    @Nonnull
    public static String getModIdFromItemStack(@Nonnull ItemStack itemStack) {
        String modid = "";
        Item item = itemStack.func_77973_b();
        if (item.getRegistryName() != null) {
            modid = item.getRegistryName().func_110624_b();
        } else {
            Platform.attemptLogErrorToCurrentMod("Could not find modid for Item: " + item.func_77658_a());
        }
        return modid;
    }

    public static boolean containsItemStack(ItemStack stack, ItemStack inputStack) {
        return ItemStack.func_179545_c((ItemStack)stack, (ItemStack)inputStack) && stack.func_190916_E() >= inputStack.func_190916_E();
    }

    public static boolean canStacksMerge(ItemStack original, ItemStack addition) {
        return ItemStack.func_179545_c((ItemStack)original, (ItemStack)addition) && ItemStack.func_77970_a((ItemStack)original, (ItemStack)addition) && original.func_77952_i() == addition.func_77952_i();
    }

    public static boolean canStacksMergeCompletely(ItemStack original, ItemStack addition) {
        return ItemStackUtils.canStacksMerge(original, addition) && original.func_190916_E() + addition.func_190916_E() <= original.func_77976_d();
    }

    public static ItemStack mergeStacks(ItemStack original, ItemStack addition) {
        int spaceToAdd;
        if (ItemStackUtils.canStacksMerge(original, addition) && (spaceToAdd = original.func_77976_d() - original.func_190916_E()) > 0) {
            int amountToAdd = addition.func_190916_E();
            if (amountToAdd > spaceToAdd) {
                amountToAdd = spaceToAdd;
            }
            addition.func_190918_g(amountToAdd);
            original.func_190917_f(amountToAdd);
        }
        return addition;
    }
}

