/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.registrysystem;

import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.registrysystem.BlockRegistry;
import com.teamacronymcoders.base.registrysystem.EntityRegistry;
import com.teamacronymcoders.base.registrysystem.ItemRegistry;
import com.teamacronymcoders.base.registrysystem.entity.SpawnInfo;
import com.teamacronymcoders.base.registrysystem.entity.UpdateInfo;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class RegistryEventHandler {
    private IBaseMod mod;
    private int nextAvailableID;

    public RegistryEventHandler(IBaseMod mod) {
        this.mod = mod;
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> blockRegistryEvent) {
        BlockRegistry blockRegistry = this.mod.getRegistryHolder().getRegistry(BlockRegistry.class, "BLOCK");
        blockRegistry.getEntries().forEach((name, block) -> blockRegistryEvent.getRegistry().register(block.setRegistryName(name)));
        blockRegistry.registryEvent();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> itemRegistryEvent) {
        ItemRegistry itemRegistry = this.mod.getRegistryHolder().getRegistry(ItemRegistry.class, "ITEM");
        itemRegistry.getEntries().forEach((name, item) -> itemRegistryEvent.getRegistry().register(item.setRegistryName(name)));
        itemRegistry.registryEvent();
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> entityRegistryEvent) {
        EntityRegistry entityRegistry = this.mod.getRegistryHolder().getRegistry(EntityRegistry.class, "ENTITY");
        entityRegistry.getEntries().forEach((name, entityEntry) -> {
            SpawnInfo spawnInfo;
            Class entityClass = entityEntry.getEntityClass();
            UpdateInfo updateInfo = entityEntry.getUpdateInfo();
            net.minecraftforge.fml.common.registry.EntityRegistry.registerModEntity((ResourceLocation)name, (Class)entityClass, (String)name.func_110623_a(), (int)this.nextAvailableID++, (Object)this.mod, (int)updateInfo.getTrackingRange(), (int)updateInfo.getUpdateFrequency(), (boolean)updateInfo.isSendVelocityUpdates());
            EntityList.EntityEggInfo spawnEgg = entityEntry.getEgg();
            if (spawnEgg != null) {
                net.minecraftforge.fml.common.registry.EntityRegistry.registerEgg((ResourceLocation)name, (int)spawnEgg.field_75611_b, (int)spawnEgg.field_75612_c);
            }
            if ((spawnInfo = entityEntry.getSpawnInfo()) != null && EntityLiving.class.isAssignableFrom(entityClass)) {
                net.minecraftforge.fml.common.registry.EntityRegistry.addSpawn((Class)entityClass, (int)spawnInfo.getWeighted(), (int)spawnInfo.getMinimum(), (int)spawnInfo.getMaximum(), (EnumCreatureType)spawnInfo.getCreatureType(), (Biome[])spawnInfo.getSpawnBiomes());
            }
        });
        entityRegistry.registryEvent();
    }

    @SubscribeEvent
    public void onModelRun(ModelRegistryEvent event) {
        this.mod.getRegistryHolder().getAllRegistries().forEach((s, registry) -> registry.onModelRun());
    }
}

