/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base;

import com.teamacronymcoders.base.BaseMods;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.IModAware;
import com.teamacronymcoders.base.guisystem.GuiHandler;
import com.teamacronymcoders.base.materialsystem.MaterialSystem;
import com.teamacronymcoders.base.materialsystem.MaterialUser;
import com.teamacronymcoders.base.modulesystem.ModuleHandler;
import com.teamacronymcoders.base.network.PacketHandler;
import com.teamacronymcoders.base.proxies.LibCommonProxy;
import com.teamacronymcoders.base.registrysystem.BlockRegistry;
import com.teamacronymcoders.base.registrysystem.EntityRegistry;
import com.teamacronymcoders.base.registrysystem.IRegistryHolder;
import com.teamacronymcoders.base.registrysystem.ItemRegistry;
import com.teamacronymcoders.base.registrysystem.Registry;
import com.teamacronymcoders.base.registrysystem.RegistryEventHandler;
import com.teamacronymcoders.base.registrysystem.config.ConfigRegistry;
import com.teamacronymcoders.base.registrysystem.pieces.IRegistryPiece;
import com.teamacronymcoders.base.registrysystem.pieces.RegistryPiece;
import com.teamacronymcoders.base.registrysystem.pieces.RegistrySide;
import com.teamacronymcoders.base.savesystem.SaveLoader;
import com.teamacronymcoders.base.subblocksystem.SubBlockSystem;
import com.teamacronymcoders.base.util.ClassLoading;
import com.teamacronymcoders.base.util.OreDictUtils;
import com.teamacronymcoders.base.util.Platform;
import com.teamacronymcoders.base.util.logging.ILogger;
import com.teamacronymcoders.base.util.logging.ModLogger;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public abstract class BaseModFoundation<T extends BaseModFoundation>
implements IBaseMod<T>,
IRegistryHolder {
    protected CreativeTabs creativeTab;
    protected ILogger logger;
    protected GuiHandler guiHandler;
    protected PacketHandler packetHandler;
    protected Map<String, Registry> registries;
    protected ModuleHandler moduleHandler;
    protected LibCommonProxy libProxy;
    protected MaterialUser materialUser;
    protected SubBlockSystem subBlockSystem;
    private String modid;
    private String modName;
    private String version;
    private File resourceFolder;
    private File minecraftFolder;

    public BaseModFoundation(String modid, String name, String version, CreativeTabs creativeTab) {
        this(modid, name, version, creativeTab, false);
    }

    public BaseModFoundation(String modid, String name, String version, CreativeTabs creativeTab, boolean optionalSystems) {
        this.modid = modid;
        this.modName = name;
        this.version = version;
        this.creativeTab = creativeTab;
        this.logger = new ModLogger(modid);
        this.packetHandler = new PacketHandler(modid);
        if (optionalSystems) {
            this.materialUser = new MaterialUser(this);
            this.subBlockSystem = new SubBlockSystem(this);
            OreDictUtils.addDefaultModId(modid);
        }
        this.libProxy = ClassLoading.createProxy("com.teamacronymcoders.base.proxies.LibClientProxy", "com.teamacronymcoders.base.proxies.LibServerProxy");
        this.getLibProxy().setMod(this);
        if (this.hasExternalResources()) {
            this.libProxy.createResourceLoader(modid);
        }
    }

    public void preInit(FMLPreInitializationEvent event) {
        BaseMods.addBaseMod(this);
        this.minecraftFolder = event.getModConfigurationDirectory().getParentFile();
        this.resourceFolder = new File(this.minecraftFolder, "resources");
        this.createRegistries(event, this.getRegistryPieces(event.getAsmData()));
        if (this.useDefaultRegistryEventHandler()) {
            MinecraftForge.EVENT_BUS.register((Object)new RegistryEventHandler(this));
        }
        this.registerBlocks(this.getRegistry(BlockRegistry.class, "BLOCK"));
        this.registerItems(this.getRegistry(ItemRegistry.class, "ITEM"));
        if (this.getMaterialUser() != null) {
            MaterialSystem.setup(this.getMaterialUser(), event.getAsmData());
            this.getMaterialUser().setup();
        }
        if (this.addOBJDomain()) {
            this.getLibProxy().addOBJDomain();
        }
        this.guiHandler = new GuiHandler(this);
        this.beforeModuleHandlerInit(event);
        this.moduleHandler = new ModuleHandler(this, event.getAsmData());
        this.getModuleHandler().setupModules();
        this.getOtherModuleHandlers().forEach(ModuleHandler::setupModules);
        this.getModuleHandler().preInit(event);
        this.getOtherModuleHandlers().forEach(otherHandler -> otherHandler.preInit(event));
        this.afterModuleHandlerInit(event);
        this.finalizeOptionalSystems();
        this.getAllRegistries().forEach((name, registry) -> registry.preInit());
    }

    public void createRegistries(FMLPreInitializationEvent event, List<IRegistryPiece> registryPieces) {
        this.addRegistry("BLOCK", new BlockRegistry(this, registryPieces));
        this.addRegistry("ITEM", new ItemRegistry(this, registryPieces));
        this.addRegistry("ENTITY", new EntityRegistry(this, registryPieces));
        if (this.hasConfig()) {
            this.addRegistry("CONFIG", new ConfigRegistry(this, event.getModConfigurationDirectory(), this.useModAsConfigFolder()));
            SaveLoader.setConfigFolder(this.getRegistry(ConfigRegistry.class, "CONFIG").getTacFolder());
        }
    }

    public void registerBlocks(BlockRegistry registry) {
    }

    public void registerItems(ItemRegistry registry) {
    }

    public void beforeModuleHandlerInit(FMLPreInitializationEvent event) {
    }

    public void afterModuleHandlerInit(FMLPreInitializationEvent event) {
    }

    public void finalizeOptionalSystems() {
        if (this.getMaterialUser() != null) {
            this.getMaterialUser().finishUp();
        }
        if (this.getSubBlockSystem() != null) {
            this.getSubBlockSystem().createBlocks();
        }
    }

    public void init(FMLInitializationEvent event) {
        this.getModuleHandler().init(event);
        this.getOtherModuleHandlers().forEach(otherHandler -> otherHandler.init(event));
        this.getAllRegistries().forEach((name, registry) -> registry.init());
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.getModuleHandler().postInit(event);
        this.getOtherModuleHandlers().forEach(otherHandler -> otherHandler.postInit(event));
        this.getAllRegistries().forEach((name, registry) -> registry.postInit());
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return this.creativeTab;
    }

    @Override
    public String getID() {
        return this.modid;
    }

    @Override
    public String getName() {
        return this.modName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean hasConfig() {
        return true;
    }

    @Override
    public String getConfigFolderName() {
        return this.getID();
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public GuiHandler getGuiHandler() {
        return this.guiHandler;
    }

    @Override
    public PacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    @Override
    public IRegistryHolder getRegistryHolder() {
        return this;
    }

    @Override
    public LibCommonProxy getLibProxy() {
        return this.libProxy;
    }

    @Override
    public ModuleHandler getModuleHandler() {
        return this.moduleHandler;
    }

    @Override
    public List<ModuleHandler> getOtherModuleHandlers() {
        return Collections.emptyList();
    }

    @Override
    public boolean addOBJDomain() {
        return false;
    }

    @Override
    @Nullable
    public MaterialUser getMaterialUser() {
        return this.materialUser;
    }

    @Override
    @Nullable
    public SubBlockSystem getSubBlockSystem() {
        return this.subBlockSystem;
    }

    @Override
    @Nullable
    public File getResourceFolder() {
        File returnFolder = null;
        if (this.hasExternalResources()) {
            returnFolder = new File(this.resourceFolder, this.modid);
        } else if (Platform.isDevEnv()) {
            returnFolder = new File(this.resourceFolder.getParentFile().getParentFile(), "/src/main/resources/assets/" + this.modid + "/");
        }
        return returnFolder;
    }

    public boolean useDefaultRegistryEventHandler() {
        return true;
    }

    public boolean useModAsConfigFolder() {
        return true;
    }

    @Override
    public Map<String, Registry> getAllRegistries() {
        return this.registries;
    }

    @Override
    public void addRegistry(String name, Registry registry) {
        if (this.registries == null) {
            this.registries = new HashMap<String, Registry>();
        }
        this.registries.put(name, registry);
    }

    @Override
    public <R extends Registry> R getRegistry(Class<R> clazz, String name) {
        Registry registry = this.registries.get(name);
        if (clazz.isInstance(registry)) {
            return (R)((Registry)clazz.cast(registry));
        }
        return null;
    }

    private List<IRegistryPiece> getRegistryPieces(ASMDataTable asmData) {
        List<IRegistryPiece> registryPieces = ClassLoading.getInstances(asmData, RegistryPiece.class, IRegistryPiece.class, aClass -> {
            RegistryPiece registryPiece = aClass.getAnnotation(RegistryPiece.class);
            RegistrySide side = registryPiece.value();
            boolean load = this.getLibProxy().isRightSide(side);
            if (load && !StringUtils.func_151246_b((String)registryPiece.modid())) {
                load = Loader.isModLoaded((String)registryPiece.modid());
            }
            return load;
        });
        registryPieces.forEach(registryPiece -> {
            if (registryPiece instanceof IModAware) {
                ((IModAware)((Object)registryPiece)).setMod(this);
            }
        });
        return registryPieces;
    }

    public File getMinecraftFolder() {
        return this.minecraftFolder;
    }
}

