/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.ModConfig;
import net.blay09.mods.farmingforblockheads.network.MessageChickenNestEffect;
import net.blay09.mods.farmingforblockheads.network.NetworkHandler;
import net.blay09.mods.farmingforblockheads.network.VanillaPacketHandler;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileChickenNest
extends TileEntity
implements ITickable {
    private static final int TICK_INTERVAL = 20;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_77973_b() != Items.field_151110_aK) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            return 4;
        }

        protected void onContentsChanged(int slot) {
            TileChickenNest.this.isDirty = true;
            TileChickenNest.this.func_70296_d();
        }
    };
    private int tickTimer;
    private boolean isDirty;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.tickTimer;
            if (this.tickTimer >= 20) {
                this.stealEgg();
                this.tickTimer = 0;
            }
            if (this.isDirty) {
                VanillaPacketHandler.sendTileEntityUpdate(this);
                this.isDirty = false;
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        return tagCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    private void stealEgg() {
        float range = ModConfig.general.chickenNestRange;
        AxisAlignedBB aabb = new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - range), (double)((float)this.field_174879_c.func_177956_o() - range), (double)((float)this.field_174879_c.func_177952_p() - range), (double)((float)this.field_174879_c.func_177958_n() + range), (double)((float)this.field_174879_c.func_177956_o() + range), (double)((float)this.field_174879_c.func_177952_p() + range));
        List list = this.field_145850_b.func_175647_a(EntityItem.class, aabb, p -> p != null && p.func_92059_d().func_77973_b() == Items.field_151110_aK && p.func_92059_d().func_190916_E() == 1 && p.func_145800_j() == null);
        if (list.isEmpty()) {
            return;
        }
        EntityItem entityItem = (EntityItem)list.get(0);
        ItemStack restStack = entityItem.func_92059_d().func_77946_l();
        for (int i = 0; i < this.itemHandler.getSlots() && !(restStack = this.itemHandler.insertItem(i, restStack, false)).func_190926_b(); ++i) {
        }
        if (restStack.func_190926_b()) {
            entityItem.func_70106_y();
            NetworkHandler.instance.sendToAllAround((IMessage)new MessageChickenNestEffect(this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
        } else {
            entityItem.func_92058_a(restStack);
        }
        this.func_70296_d();
    }

    public int getEggCount() {
        return this.itemHandler.getStackInSlot(0).func_190916_E();
    }
}

