/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import java.io.File;
import java.util.Optional;
import net.blay09.mods.farmingforblockheads.CommandFarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.CommonProxy;
import net.blay09.mods.farmingforblockheads.FarmlandHandler;
import net.blay09.mods.farmingforblockheads.IMCHandler;
import net.blay09.mods.farmingforblockheads.InternalMethodsImpl;
import net.blay09.mods.farmingforblockheads.ModConfig;
import net.blay09.mods.farmingforblockheads.ModSounds;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.compat.VanillaAddon;
import net.blay09.mods.farmingforblockheads.entity.EntityMerchant;
import net.blay09.mods.farmingforblockheads.item.ModItems;
import net.blay09.mods.farmingforblockheads.network.GuiHandler;
import net.blay09.mods.farmingforblockheads.network.NetworkHandler;
import net.blay09.mods.farmingforblockheads.registry.AbstractRegistry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="farmingforblockheads", name="Farming for Blockheads", dependencies="after:mousetweaks[2.8,);after:forestry;after:agricraft", acceptedMinecraftVersions="[1.12]")
@Mod.EventBusSubscriber
public class FarmingForBlockheads {
    public static final String MOD_ID = "farmingforblockheads";
    @Mod.Instance(value="farmingforblockheads")
    public static FarmingForBlockheads instance;
    @SidedProxy(clientSide="net.blay09.mods.farmingforblockheads.client.ClientProxy", serverSide="net.blay09.mods.farmingforblockheads.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static final CreativeTabs creativeTab;
    public static File configDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        configDir = new File(event.getModConfigurationDirectory(), "FarmingForBlockheads");
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new RuntimeException("Couldn't create Farming for Blockheads configuration directory");
        }
        FarmingForBlockheadsAPI.__setupAPI(new InternalMethodsImpl());
        ResourceLocation CATEGORY_ICONS = new ResourceLocation(MOD_ID, "textures/gui/market.png");
        FarmingForBlockheadsAPI.registerMarketCategory(new ResourceLocation(MOD_ID, "seeds"), "gui.farmingforblockheads:market.tooltip_seeds", CATEGORY_ICONS, 196, 14, 10);
        FarmingForBlockheadsAPI.registerMarketCategory(new ResourceLocation(MOD_ID, "saplings"), "gui.farmingforblockheads:market.tooltip_saplings", CATEGORY_ICONS, 216, 14, 20);
        FarmingForBlockheadsAPI.registerMarketCategory(new ResourceLocation(MOD_ID, "flowers"), "gui.farmingforblockheads:market.tooltip_flowers", CATEGORY_ICONS, 176, 74, 30);
        FarmingForBlockheadsAPI.registerMarketCategory(new ResourceLocation(MOD_ID, "other"), "gui.farmingforblockheads:market.tooltip_other", CATEGORY_ICONS, 236, 14, 40);
        ModBlocks.registerTileEntities();
        MinecraftForge.EVENT_BUS.register((Object)new FarmlandHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModConfig.validate();
        NetworkHandler.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        new VanillaAddon();
        this.buildSoftDependProxy("harvestcraft", "net.blay09.mods.farmingforblockheads.compat.HarvestcraftAddon");
        this.buildSoftDependProxy("forestry", "net.blay09.mods.farmingforblockheads.compat.ForestryAddon");
        this.buildSoftDependProxy("agricraft", "net.blay09.mods.farmingforblockheads.compat.AgriCraftAddon");
        this.buildSoftDependProxy("biomesoplenty", "net.blay09.mods.farmingforblockheads.compat.BiomesOPlentyAddon");
        this.buildSoftDependProxy("natura", "net.blay09.mods.farmingforblockheads.compat.NaturaAddon");
        this.buildSoftDependProxy("terraqueous", "net.blay09.mods.farmingforblockheads.compat.TerraqueousAddon");
        MarketRegistry.INSTANCE.load(configDir);
    }

    @Mod.EventHandler
    public void imc(FMLInterModComms.IMCEvent event) {
        IMCHandler.handleIMCMessage(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandFarmingForBlockheads());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        ModItems.register((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        ModSounds.register((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("farmingforblockheads:merchant"), EntityMerchant.class, (String)"merchant", (int)0, (Object)instance, (int)64, (int)3, (boolean)true);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModBlocks.registerModels();
        ModItems.registerModels();
        proxy.registerModels();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (AbstractRegistry.registryErrors.size() > 0) {
            event.player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "There were errors loading the Farming for Blockheads registries:"), false);
            TextFormatting lastFormatting = TextFormatting.WHITE;
            for (String error : AbstractRegistry.registryErrors) {
                event.player.func_146105_b((ITextComponent)new TextComponentString(lastFormatting + "* " + error), false);
                lastFormatting = lastFormatting == TextFormatting.GRAY ? TextFormatting.WHITE : TextFormatting.GRAY;
            }
        }
    }

    private Optional<?> buildSoftDependProxy(String modId, String className) {
        if (Loader.isModLoaded((String)modId)) {
            try {
                Class<?> clz = Class.forName(className, true, (ClassLoader)Loader.instance().getModClassLoader());
                return Optional.ofNullable(clz.newInstance());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    static {
        creativeTab = new CreativeTabs(MOD_ID){

            public ItemStack func_78016_d() {
                return new ItemStack(ModBlocks.market);
            }
        };
    }
}

