/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.woodenbucket;

import com.builtbroken.mc.fluids.api.reg.BucketMaterialRegistryEvent;
import com.builtbroken.mc.fluids.bucket.BucketMaterial;
import com.builtbroken.mc.fluids.bucket.BucketMaterialHandler;
import com.builtbroken.woodenbucket.BucketTypes;
import com.builtbroken.woodenbucket.WoodenBucketMaterial;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="woodenbucket", name="Wooden Bucket", version="0.2.0.10", dependencies="after:vefluids", acceptedMinecraftVersions="[1.12]")
@Mod.EventBusSubscriber(modid="woodenbucket")
public class WoodenBucket {
    public static final String DOMAIN = "woodenbucket";
    public static final String PREFIX = "woodenbucket:";
    public static Logger LOGGER;
    public static Configuration config;
    public static boolean PREVENT_HOT_FLUID_USAGE;
    public static boolean DAMAGE_BUCKET_WITH_HOT_FLUID;
    public static boolean BURN_ENTITY_WITH_HOT_FLUID;
    public static boolean ENABLE_FLUID_LEAKING;
    public static boolean ALLOW_LEAK_TO_CAUSE_FIRES;
    public static int VISCOSITY_TO_IGNORE_LEAKING;
    public static int AMOUNT_TO_LEAK;
    public static float CHANCE_TO_LEAK;
    public static float LEAK_FIRE_CHANCE;

    public WoodenBucket() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = LogManager.getLogger((String)"WoodenBucket");
        config = new Configuration(new File(event.getModConfigurationDirectory(), "bbm/Wooden_Bucket.cfg"));
        config.load();
    }

    @SubscribeEvent
    public void registerBucketMaterials(BucketMaterialRegistryEvent.Pre event) {
        for (BucketTypes type : BucketTypes.values()) {
            type.material = new WoodenBucketMaterial(type);
            BucketMaterialHandler.addMaterial((String)type.name().toLowerCase(), (BucketMaterial)type.material, (int)type.ordinal());
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ResourceLocation location = new ResourceLocation(DOMAIN, DOMAIN);
        event.getRegistry().register(new ShapedOreRecipe(location, BucketTypes.OAK.getBucket(), new Object[]{" s ", "wcw", " w ", Character.valueOf('w'), new ItemStack(Blocks.field_150344_f, 1, 0), Character.valueOf('s'), "stickWood", Character.valueOf('c'), "dye"}).setRegistryName("bucket.wood.oak"));
        event.getRegistry().register(new ShapedOreRecipe(location, BucketTypes.SPRUCE.getBucket(), new Object[]{" s ", "wcw", " w ", Character.valueOf('w'), new ItemStack(Blocks.field_150344_f, 1, 1), Character.valueOf('s'), "stickWood", Character.valueOf('c'), "dye"}).setRegistryName("bucket.wood.spruce"));
        event.getRegistry().register(new ShapedOreRecipe(location, BucketTypes.BIRCH.getBucket(), new Object[]{" s ", "wcw", " w ", Character.valueOf('w'), new ItemStack(Blocks.field_150344_f, 1, 2), Character.valueOf('s'), "stickWood", Character.valueOf('c'), "dye"}).setRegistryName("bucket.wood.birch"));
        event.getRegistry().register(new ShapedOreRecipe(location, BucketTypes.JUNGLE.getBucket(), new Object[]{" s ", "wcw", " w ", Character.valueOf('w'), new ItemStack(Blocks.field_150344_f, 1, 3), Character.valueOf('s'), "stickWood", Character.valueOf('c'), "dye"}).setRegistryName("bucket.wood.jungle"));
        event.getRegistry().register(new ShapedOreRecipe(location, BucketTypes.ACACIA.getBucket(), new Object[]{" s ", "wcw", " w ", Character.valueOf('w'), new ItemStack(Blocks.field_150344_f, 1, 4), Character.valueOf('s'), "stickWood", Character.valueOf('c'), "dye"}).setRegistryName("bucket.wood.acacia"));
        event.getRegistry().register(new ShapedOreRecipe(location, BucketTypes.BIG_OAK.getBucket(), new Object[]{" s ", "wcw", " w ", Character.valueOf('w'), new ItemStack(Blocks.field_150344_f, 1, 5), Character.valueOf('s'), "stickWood", Character.valueOf('c'), "dye"}).setRegistryName("bucket.wood.big_oak"));
        for (ItemStack itemstack : OreDictionary.getOres((String)"planks")) {
            if (itemstack == null || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150344_f)) continue;
            event.getRegistry().register(new ShapedOreRecipe(location, BucketTypes.OAK.getBucket(), new Object[]{" s ", "wcw", " w ", Character.valueOf('w'), itemstack, Character.valueOf('s'), "stickWood", Character.valueOf('c'), "dye"}).setRegistryName("bucket.wood." + itemstack.func_77977_a()));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PREVENT_HOT_FLUID_USAGE = config.getBoolean("PreventHotFluidUsage", "WoodenBucketUsage", PREVENT_HOT_FLUID_USAGE, "Enables settings that attempt to prevent players from wanting to use the bucket for moving hot fluids");
        DAMAGE_BUCKET_WITH_HOT_FLUID = config.getBoolean("DamageBucketWithHotFluid", "WoodenBucketUsage", DAMAGE_BUCKET_WITH_HOT_FLUID, "Will randomly destroy the bucket if it contains hot fluid, lava in other words");
        BURN_ENTITY_WITH_HOT_FLUID = config.getBoolean("BurnPlayerWithHotFluid", "WoodenBucketUsage", BURN_ENTITY_WITH_HOT_FLUID, "Will light the player on fire if the bucket contains a hot fluid, lava in other words");
        ENABLE_FLUID_LEAKING = config.getBoolean("Enable", "Leaking", ENABLE_FLUID_LEAKING, "Allows fluid to slowly leak out of the bucket as a nerf. Requested by Darkosto");
        VISCOSITY_TO_IGNORE_LEAKING = config.getInt("MaxViscosity", "Leaking", VISCOSITY_TO_IGNORE_LEAKING, -1, 10000, "At which point it the flow rate so slow that the leak is plugged, higher values are slower");
        AMOUNT_TO_LEAK = config.getInt("MaxLeakAmount", "Leaking", AMOUNT_TO_LEAK, 0, 10000, "How much can leak from the bucket each time a leak happens, number is max amount and is randomly ranged between 0 - #");
        CHANCE_TO_LEAK = config.getFloat("LeakChance", "Leaking", CHANCE_TO_LEAK, 0.0f, 1.0f, "What is the chance that a leak will happen, calculated each tick with high numbers being more often");
        ALLOW_LEAK_TO_CAUSE_FIRES = config.getBoolean("AllowFires", "Leaking", ALLOW_LEAK_TO_CAUSE_FIRES, "If molten fluid leaks, should there be a chance to cause fires?");
        LEAK_FIRE_CHANCE = config.getFloat("FireChance", "Leaking", LEAK_FIRE_CHANCE, 0.0f, 1.0f, "How often to cause fire from molten fluids leaking");
        for (BucketTypes type : BucketTypes.values()) {
            type.material.preventHotFluidUsage = PREVENT_HOT_FLUID_USAGE;
            type.material.damageBucketWithHotFluid = DAMAGE_BUCKET_WITH_HOT_FLUID;
            type.material.burnEntityWithHotFluid = BURN_ENTITY_WITH_HOT_FLUID;
            type.material.enableFluidLeaking = ENABLE_FLUID_LEAKING;
            type.material.viscosityToIgnoreLeaking = VISCOSITY_TO_IGNORE_LEAKING;
            type.material.amountToLeak = AMOUNT_TO_LEAK;
            type.material.chanceToLeak = CHANCE_TO_LEAK;
            type.material.allowLeakToCauseFires = ALLOW_LEAK_TO_CAUSE_FIRES;
            type.material.leakFireChance = LEAK_FIRE_CHANCE;
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        PREVENT_HOT_FLUID_USAGE = true;
        DAMAGE_BUCKET_WITH_HOT_FLUID = true;
        BURN_ENTITY_WITH_HOT_FLUID = true;
        ENABLE_FLUID_LEAKING = false;
        ALLOW_LEAK_TO_CAUSE_FIRES = true;
        VISCOSITY_TO_IGNORE_LEAKING = 3000;
        AMOUNT_TO_LEAK = 1;
        CHANCE_TO_LEAK = 0.03f;
        LEAK_FIRE_CHANCE = 0.4f;
    }
}

