/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thaumcraft.handlers.handlers;

import com.blamejared.ModTweaker;
import com.blamejared.compat.thaumcraft.handlers.ThaumCraft;
import com.blamejared.compat.thaumcraft.handlers.aspects.CTAspectStack;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.internal.CommonInternals;

@ZenClass(value="mods.thaumcraft.Crucible")
@ZenRegister
@ModOnly(value="thaumcraft")
public class Crucible {
    @ZenMethod
    public static void registerRecipe(String name, String researchKey, IItemStack output, IIngredient input, CTAspectStack[] aspects) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(new ResourceLocation("modtweaker", name), researchKey, InputHelper.toStack((IItemStack)output), InputHelper.toObject((IIngredient)input), ThaumCraft.getAspects(aspects)));
    }

    @ZenMethod
    public static void removeRecipe(String name) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(name));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(output));
    }

    public static class Remove
    extends BaseAction {
        private String name;
        private IItemStack output;

        protected Remove(String name) {
            super("Crucible");
            this.name = name;
        }

        protected Remove(IItemStack output) {
            super("Crucible");
            this.output = output;
        }

        public void apply() {
            ArrayList toRemove = new ArrayList();
            for (Map.Entry entry : CommonInternals.craftingRecipeCatalog.entrySet()) {
                if (!(entry.getValue() instanceof CrucibleRecipe)) continue;
                if (this.name != null && !this.name.isEmpty() && ((ResourceLocation)entry.getKey()).toString().equals(this.name)) {
                    toRemove.add(entry.getKey());
                }
                if (this.output.isEmpty() || !this.output.matches(InputHelper.toIItemStack((ItemStack)((CrucibleRecipe)entry.getValue()).getRecipeOutput()))) continue;
                toRemove.add(entry.getKey());
            }
            toRemove.forEach(CommonInternals.craftingRecipeCatalog::remove);
        }
    }

    public static class Add
    extends BaseAction {
        private ResourceLocation name;
        private String research;
        private ItemStack output;
        private Object input;
        private AspectList aspects;

        public Add(ResourceLocation name1, String research, ItemStack output, Object input, AspectList aspects) {
            super("Crucible");
            this.name = name1;
            this.research = research;
            this.output = output;
            this.input = input;
            this.aspects = aspects;
        }

        public void apply() {
            ThaumcraftApi.addCrucibleRecipe((ResourceLocation)this.name, (CrucibleRecipe)new CrucibleRecipe(this.research, this.output, this.input, this.aspects));
        }
    }
}

