/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.thedragonlib.config.Feature;
import net.thedragonteam.thedragonlib.config.ICustomRegistry;
import net.thedragonteam.thedragonlib.config.ICustomRender;
import net.thedragonteam.thedragonlib.util.LogHelper;
import net.thedragonteam.thedragonlib.util.Utils;

public class ModFeatureParser {
    private String modid;
    private CreativeTabs[] modTabs;
    private static final String CATEGORY_BLOCKS = "Blocks";
    private static final String CATEGORY_ITEMS = "Items";
    private static final Map<Object, Boolean> featureStates = new HashMap<Object, Boolean>();
    private static final List<FeatureEntry> featureEntries = new ArrayList<FeatureEntry>();

    public ModFeatureParser(String modid, CreativeTabs[] modTabs) {
        this.modid = modid;
        this.modTabs = modTabs;
    }

    public void loadFeatures(Class collection) {
        Arrays.stream(collection.getFields()).filter(field -> field.isAnnotationPresent(Feature.class)).forEachOrdered(field -> {
            try {
                featureEntries.add(new FeatureEntry(field.get(null), field.getAnnotation(Feature.class)));
            }
            catch (IllegalAccessException e) {
                LogHelper.error("Error Loading Feature!!! [" + field.getAnnotation(Feature.class).name() + "]");
                e.printStackTrace();
            }
        });
    }

    public void loadFeatureConfig(Configuration configuration) {
        try {
            featureEntries.forEach(entry -> {
                Feature feature = ((FeatureEntry)entry).feature;
                if (!feature.isConfigurable()) {
                    featureStates.put(((FeatureEntry)entry).featureObj, true);
                    return;
                }
                String category = ((FeatureEntry)entry).featureObj instanceof Block ? CATEGORY_BLOCKS : CATEGORY_ITEMS;
                entry.enabled = configuration.get(category, feature.name(), feature.isActive()).getBoolean(feature.isActive());
                featureStates.put(((FeatureEntry)entry).featureObj, entry.enabled);
            });
        }
        catch (Exception var4) {
            LogHelper.error("Error Loading Block/Item Config");
            var4.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public void registerFeatures() {
        featureEntries.stream().filter(entry -> entry.enabled).filter(entry -> ((FeatureEntry)entry).featureObj instanceof ICustomRegistry).forEachOrdered(entry -> ((ICustomRegistry)((FeatureEntry)entry).featureObj).registerFeature(((FeatureEntry)entry).feature));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRendering() {
        for (FeatureEntry entry : featureEntries) {
            Feature feature = entry.feature;
            Object featureObj = entry.featureObj;
            ResourceLocation rl = Utils.toRL(this.modid + feature.name());
            if (!entry.enabled) continue;
            if (featureObj instanceof ICustomRender) {
                ICustomRender customRender = (ICustomRender)featureObj;
                customRender.registerRenderer(feature);
                if (!customRender.registerNormal(feature)) continue;
            }
            if (featureObj instanceof Block) {
                Block block = (Block)featureObj;
                if (feature.variantMap().length > 0) {
                    this.registerVariants(Item.func_150898_a((Block)block), feature);
                    continue;
                }
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(rl.toString()));
                continue;
            }
            if (!(featureObj instanceof Item)) continue;
            Item item = (Item)featureObj;
            if (!feature.stateOverride().isEmpty()) {
                String s = feature.stateOverride().substring(0, feature.stateOverride().indexOf("#"));
                s = s + feature.stateOverride().substring(feature.stateOverride().indexOf("#")).toLowerCase();
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.modid.toLowerCase() + ":" + s));
                continue;
            }
            if (feature.variantMap().length > 0) {
                this.registerVariants(item, feature);
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(rl.toString()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerVariants(Item item, Feature feature) {
        Arrays.stream(feature.variantMap()).forEachOrdered(s -> {
            int meta = Integer.parseInt(s.substring(0, s.indexOf(":")));
            ResourceLocation fullName = Utils.toRL(this.modid, feature.name());
            String variant = s.substring(s.indexOf(":") + 1);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(fullName, variant));
        });
    }

    public static boolean isFeature(Object object) {
        return featureStates.containsKey(object);
    }

    public static boolean isEnabled(Object feature) {
        return featureStates.getOrDefault(feature, false);
    }

    private static class FeatureEntry {
        private final Object featureObj;
        private final Feature feature;
        public boolean enabled;

        private FeatureEntry(Object featureObj, Feature feature) {
            this.featureObj = featureObj;
            this.feature = feature;
            this.enabled = feature.isActive();
        }
    }
}

