/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.config;

import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.thedragonteam.thedragonlib.config.ModConfigProperty;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class ModConfigProcessor {
    private Class configClass;
    private Configuration config;

    public void processConfig(Class configClass, Configuration config) {
        this.configClass = configClass;
        this.config = config;
        Arrays.stream(configClass.getFields()).filter(field -> field.isAnnotationPresent(ModConfigProperty.class)).forEachOrdered(field -> {
            ModConfigProperty property = field.getAnnotation(ModConfigProperty.class);
            try {
                Object defaultValue = field.get(null);
                Object newValue = ModConfigProcessor.getConfigValue(defaultValue, config, property);
                field.set(null, newValue);
            }
            catch (Exception e) {
                LogHelper.error("Something when wrong while loading config value [" + property.name() + "]");
                e.printStackTrace();
            }
        });
        this.saveConfig();
    }

    public static Object getConfigValue(Object defaultValue, Configuration configuration, ModConfigProperty property) throws Exception {
        String category = property.category();
        String name = property.name();
        String comment = property.comment();
        if (defaultValue instanceof Boolean) {
            return configuration.get(category, name, ((Boolean)defaultValue).booleanValue(), comment).getBoolean(((Boolean)defaultValue).booleanValue());
        }
        if (defaultValue instanceof boolean[]) {
            return configuration.get(category, name, (boolean[])defaultValue, comment).getBooleanList();
        }
        if (defaultValue instanceof Double) {
            return configuration.get(category, name, ((Double)defaultValue).doubleValue(), comment).getDouble(((Double)defaultValue).doubleValue());
        }
        if (defaultValue instanceof double[]) {
            return configuration.get(category, name, (double[])defaultValue, comment).getDoubleList();
        }
        if (defaultValue instanceof Integer) {
            return configuration.get(category, name, ((Integer)defaultValue).intValue(), comment).getInt(((Integer)defaultValue).intValue());
        }
        if (defaultValue instanceof int[]) {
            return configuration.get(category, name, (int[])defaultValue, comment).getIntList();
        }
        if (defaultValue instanceof String) {
            return configuration.get(category, name, (String)defaultValue, comment).getString();
        }
        if (defaultValue instanceof String[]) {
            return configuration.get(category, name, (String[])defaultValue, comment).getStringList();
        }
        throw new Exception("Config data class is unknown");
    }

    public Property findProperty(String category, String name) {
        return this.config.getCategory(category) != null ? this.config.getCategory(category).get(name) : null;
    }

    public void saveConfig() {
        if (this.config != null && this.config.hasChanged()) {
            this.config.save();
        }
    }
}

