/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import java.util.Random;
import net.blay09.mods.kleeslabs.JsonCompatLoader;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="kleeslabs", name="KleeSlabs", acceptedMinecraftVersions="[1.12]")
public class KleeSlabs {
    public static final String MOD_ID = "kleeslabs";
    public static final Logger logger = LogManager.getLogger();
    private static final Random rand = new Random();
    public static Configuration config;
    public static File configDir;
    private boolean requireSneak;
    private boolean invertSneak;
    private static final Map<Block, SlabConverter> slabMap;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDir = event.getModConfigurationDirectory();
        MinecraftForge.EVENT_BUS.register((Object)this);
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.requireSneak = config.getBoolean("Require Sneaking", "general", false, "Set this to true to only break half a slab when the player is sneaking.");
        this.invertSneak = config.getBoolean("Invert Sneaking Check", "general", false, "If Require Sneaking is enabled. Set this to true to invert the sneaking check for breaking only half a slab.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        JsonCompatLoader.loadCompat();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void registerSlabConverter(Block doubleSlab, SlabConverter converter) {
        slabMap.put(doubleSlab, converter);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (!this.requireSneak || event.getPlayer().func_70093_af() != this.invertSneak) {
            if (event.getTarget().field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            BlockPos pos = event.getTarget().func_178782_a();
            if (pos == null) {
                return;
            }
            IBlockState target = event.getPlayer().field_70170_p.func_180495_p(pos);
            SlabConverter slabConverter = slabMap.get(target.func_177230_c());
            if (slabConverter != null) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187441_d((float)2.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                EntityPlayer player = event.getPlayer();
                double offsetX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                double offsetY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                double offsetZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                AxisAlignedBB halfAABB = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + 0.5, (double)(pos.func_177952_p() + 1));
                if (event.getTarget().field_72307_f.field_72448_b - player.field_70163_u > 0.5) {
                    halfAABB = halfAABB.func_72317_d(0.0, 0.5, 0.0);
                }
                RenderGlobal.func_189697_a((AxisAlignedBB)halfAABB.func_186662_g(0.002).func_72317_d(-offsetX, -offsetY, -offsetZ), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        Vec3d hitVec;
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        RayTraceResult mop = KleeSlabs.rayTrace((EntityLivingBase)event.getPlayer(), 6.0);
        Vec3d vec3d = hitVec = mop != null ? mop.field_72307_f : null;
        if (hitVec != null) {
            hitVec = hitVec.func_72441_c((double)(-event.getPos().func_177958_n()), (double)(-event.getPos().func_177956_o()), (double)(-event.getPos().func_177952_p()));
        }
        if (!this.requireSneak || event.getPlayer().func_70093_af() != this.invertSneak) {
            Item slabItem;
            IBlockState state = event.getState();
            SlabConverter slabConverter = slabMap.get(state.func_177230_c());
            if (slabConverter == null || !slabConverter.isDoubleSlab(state)) {
                return;
            }
            IBlockState dropState = slabConverter.getSingleSlab(state, BlockSlab.EnumBlockHalf.BOTTOM);
            if (!event.getWorld().field_72995_K && event.getPlayer().func_184823_b(event.getState()) && !event.getPlayer().field_71075_bZ.field_75098_d && (slabItem = Item.func_150898_a((Block)dropState.func_177230_c())) != Items.field_190931_a) {
                this.spawnItem(new ItemStack(slabItem, 1, dropState.func_177230_c().func_180651_a(dropState)), event.getWorld(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
            }
            IBlockState newState = hitVec != null && hitVec.field_72448_b < 0.5 ? slabConverter.getSingleSlab(state, BlockSlab.EnumBlockHalf.TOP) : slabConverter.getSingleSlab(state, BlockSlab.EnumBlockHalf.BOTTOM);
            event.getWorld().func_180501_a(event.getPos(), newState, 3);
            event.setCanceled(true);
        }
    }

    private void spawnItem(ItemStack itemStack, World world, float x, float y, float z) {
        float scale = 0.7f;
        double xOffset = (double)(rand.nextFloat() * scale + 1.0f) - (double)scale * 0.5;
        double yOffset = (double)(rand.nextFloat() * scale + 1.0f) - (double)scale * 0.5;
        double zOffset = (double)(rand.nextFloat() * scale + 1.0f) - (double)scale * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)x + xOffset, (double)y + yOffset, (double)z + zOffset, itemStack);
        entityItem.func_174867_a(10);
        world.func_72838_d((Entity)entityItem);
    }

    public static RayTraceResult rayTrace(EntityLivingBase entity, double length) {
        Vec3d startPos = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        Vec3d endPos = startPos.func_72441_c(entity.func_70040_Z().field_72450_a * length, entity.func_70040_Z().field_72448_b * length, entity.func_70040_Z().field_72449_c * length);
        return entity.field_70170_p.func_72933_a(startPos, endPos);
    }

    static {
        slabMap = Maps.newHashMap();
    }

    private static class SlabDebugger {
        private SlabDebugger() {
        }

        @SubscribeEvent
        public void onTooltip(ItemTooltipEvent event) {
            event.getToolTip().add("Mod: " + event.getItemStack().func_77973_b().getRegistryName().func_110624_b());
            event.getToolTip().add("Name: " + event.getItemStack().func_77973_b().getRegistryName().func_110623_a());
        }

        @SubscribeEvent
        public void onRightClick(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getSide() == Side.CLIENT) {
                IBlockState state = event.getWorld().func_180495_p(event.getPos());
                event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentString("Mod: " + state.func_177230_c().getRegistryName().func_110624_b() + " Name: " + state.func_177230_c().getRegistryName().func_110623_a()), false);
            }
        }
    }
}

