/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.placeholders.tasks.FactoryTaskPlaceholder;
import betterquesting.api.placeholders.tasks.TaskPlaceholder;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabaseNBT;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.questing.tasks.TaskRegistry;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class TaskStorage
extends SimpleDatabase<ITask>
implements IDatabaseNBT<ITask, NBTTagList> {
    @Override
    public NBTTagList writeToNBT(NBTTagList json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                return this.writeToJson_Config(json);
            }
            case PROGRESS: {
                return this.writeToJson_Progress(json);
            }
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagList json, EnumSaveType saveType) {
        switch (saveType) {
            case CONFIG: {
                this.readFromJson_Config(json);
                break;
            }
            case PROGRESS: {
                this.readFromJson_Progress(json);
                break;
            }
        }
    }

    private NBTTagList writeToJson_Config(NBTTagList json) {
        for (DBEntry entry : this.getEntries()) {
            ResourceLocation taskID = ((ITask)entry.getValue()).getFactoryID();
            NBTTagCompound qJson = ((ITask)entry.getValue()).writeToNBT(new NBTTagCompound(), EnumSaveType.CONFIG);
            qJson.func_74778_a("taskID", taskID.toString());
            qJson.func_74768_a("index", entry.getID());
            json.func_74742_a((NBTBase)qJson);
        }
        return json;
    }

    private void readFromJson_Config(NBTTagList json) {
        this.reset();
        ArrayList<ITask> unassigned = new ArrayList<ITask>();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTTagCompound jt2;
            ResourceLocation loc2;
            ITask t2;
            NBTBase entry = json.func_179238_g(i);
            if (entry.func_74732_a() != 10) continue;
            NBTTagCompound jsonTask = (NBTTagCompound)entry;
            ResourceLocation loc = new ResourceLocation(jsonTask.func_74779_i("taskID"));
            int index = jsonTask.func_150297_b("index", 99) ? jsonTask.func_74762_e("index") : -1;
            ITask task = TaskRegistry.INSTANCE.createTask(loc);
            if (task instanceof TaskPlaceholder && (t2 = TaskRegistry.INSTANCE.createTask(loc2 = new ResourceLocation((jt2 = jsonTask.func_74775_l("orig_data")).func_74779_i("taskID")))) != null) {
                jsonTask = jt2;
                task = t2;
            }
            if (task != null) {
                task.readFromNBT(jsonTask, EnumSaveType.CONFIG);
                if (index >= 0) {
                    this.add(index, task);
                    continue;
                }
                unassigned.add(task);
                continue;
            }
            TaskPlaceholder tph = new TaskPlaceholder();
            tph.setTaskData(jsonTask, EnumSaveType.CONFIG);
            if (index >= 0) {
                this.add(index, tph);
                continue;
            }
            unassigned.add(tph);
        }
        for (ITask t : unassigned) {
            this.add(this.nextID(), t);
        }
    }

    private NBTTagList writeToJson_Progress(NBTTagList json) {
        for (DBEntry entry : this.getEntries()) {
            ResourceLocation taskID = ((ITask)entry.getValue()).getFactoryID();
            NBTTagCompound qJson = ((ITask)entry.getValue()).writeToNBT(new NBTTagCompound(), EnumSaveType.PROGRESS);
            qJson.func_74778_a("taskID", taskID.toString());
            qJson.func_74768_a("index", entry.getID());
            json.func_74742_a((NBTBase)qJson);
        }
        return json;
    }

    private void readFromJson_Progress(NBTTagList json) {
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTBase entry = json.func_179238_g(i);
            if (entry.func_74732_a() != 10) continue;
            NBTTagCompound jsonTask = (NBTTagCompound)entry;
            int index = jsonTask.func_150297_b("index", 99) ? jsonTask.func_74762_e("index") : -1;
            ResourceLocation loc = new ResourceLocation(jsonTask.func_74779_i("taskID"));
            ITask task = (ITask)this.getValue(index);
            if (task instanceof TaskPlaceholder) {
                if (!task.getFactoryID().equals((Object)loc)) {
                    ((TaskPlaceholder)task).setTaskData(jsonTask, EnumSaveType.PROGRESS);
                    continue;
                }
                task.readFromNBT(jsonTask, EnumSaveType.PROGRESS);
                continue;
            }
            if (task == null) continue;
            if (task.getFactoryID().equals((Object)loc)) {
                task.readFromNBT(jsonTask, EnumSaveType.PROGRESS);
                continue;
            }
            if (!FactoryTaskPlaceholder.INSTANCE.getRegistryName().equals((Object)loc)) continue;
            task.readFromNBT(jsonTask.func_74775_l("orig_prog"), EnumSaveType.PROGRESS);
        }
    }
}

