/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui.editors.GuiQuestLineEditorA;
import betterquesting.client.gui2.CanvasQuestLine;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class GuiQuestLines
extends GuiScreenCanvas
implements IPEventListener {
    private IQuestLine selectedLine = null;
    private int selectedLineId = -1;
    private int lastScrollX = 0;
    private int lastScrollY = 0;
    private float lastZoom = 1.0f;
    private PanelButtonStorage[] qlBtns;
    private CanvasQuestLine cvQuest;
    private CanvasScrolling cvDesc;
    private PanelVScrollBar scDesc;
    private PanelTextBox paDesc;

    public GuiQuestLines(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initPanel() {
        super.initPanel();
        if (this.selectedLineId >= 0) {
            this.selectedLine = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(this.selectedLineId);
            if (this.selectedLine == null) {
                this.selectedLineId = -1;
            }
        } else {
            this.selectedLine = null;
        }
        boolean canEdit = QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g);
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        if (canEdit) {
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 100, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -16, 100, 16, 0), 3, QuestTranslation.translate("betterquesting.btn.edit", new Object[0])));
        } else {
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        }
        CanvasScrolling cvList = new CanvasScrolling(new GuiTransform(GuiAlign.LEFT_EDGE, new GuiPadding(16, 16, -158, 16), 0));
        cvBackground.addPanel(cvList);
        PanelVScrollBar pnQScroll = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(0, 0, -8, 0), 0));
        cvList.setScrollDriverY(pnQScroll);
        cvBackground.addPanel(pnQScroll);
        pnQScroll.getTransform().setParent(cvList.getTransform());
        DBEntry<IQuestLine>[] lineList = QuestLineDatabase.INSTANCE.getSortedEntries();
        this.qlBtns = new PanelButtonStorage[lineList.length];
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        for (int i = 0; i < lineList.length; ++i) {
            IQuestLine ql = lineList[i].getValue();
            PanelButtonStorage<IQuestLine> btnLine = new PanelButtonStorage<IQuestLine>(new GuiRectangle(0, i * 16, 142, 16, 0), 1, QuestTranslation.translate(ql.getUnlocalisedName(), new Object[0]), ql);
            boolean show = canEdit;
            if (!show) {
                for (DBEntry qID : ql.getEntries()) {
                    IQuest q = (IQuest)QuestDatabase.INSTANCE.getValue(qID.getID());
                    if (q == null || !CanvasQuestLine.isQuestShown(q, playerID)) continue;
                    show = true;
                    break;
                }
            }
            if (!show || ql == this.selectedLine) {
                btnLine.setActive(false);
            }
            cvList.addPanel(btnLine);
            this.qlBtns[i] = btnLine;
        }
        pnQScroll.setEnabled(cvList.getScrollBounds().getHeight() > 0);
        CanvasTextured cvFrame = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(174, 16, 16, 66), 0), PresetTexture.AUX_FRAME_0.getTexture());
        cvBackground.addPanel(cvFrame);
        this.cvQuest = new CanvasQuestLine(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), 2);
        cvFrame.addPanel(this.cvQuest);
        this.cvDesc = new CanvasScrolling(new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(174, -66, 24, 16), 0));
        cvBackground.addPanel(this.cvDesc);
        this.paDesc = new PanelTextBox(new GuiRectangle(0, 0, this.cvDesc.getTransform().getWidth(), 0, 0), "", true);
        this.paDesc.setColor(PresetColor.TEXT_MAIN.getColor());
        this.cvDesc.addCulledPanel(this.paDesc, false);
        this.scDesc = new PanelVScrollBar(new GuiTransform(GuiAlign.BOTTOM_RIGHT, new GuiPadding(-24, -66, 16, 16), 0));
        this.cvDesc.setScrollDriverY(this.scDesc);
        cvBackground.addPanel(this.scDesc);
        if (this.selectedLine != null) {
            this.cvQuest.setQuestLine(this.selectedLine);
            this.cvQuest.setZoom(this.lastZoom);
            this.cvQuest.setScrollX(this.lastScrollX);
            this.cvQuest.setScrollY(this.lastScrollY);
            this.paDesc.setText(QuestTranslation.translate(this.selectedLine.getUnlocalisedDescription(), new Object[0]));
            this.scDesc.setEnabled(this.cvDesc.getScrollBounds().getHeight() > 0);
        }
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_LEFT, 16, 16, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.TOP_LEFT, 166, 16, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), -1);
        cvBackground.addPanel(paLine0);
        GuiTransform ls1 = new GuiTransform(GuiAlign.BOTTOM_LEFT, 16, -16, 0, 0, 0);
        ls1.setParent(cvBackground.getTransform());
        GuiTransform le1 = new GuiTransform(GuiAlign.BOTTOM_LEFT, 166, -16, 0, 0, 0);
        le1.setParent(cvBackground.getTransform());
        PanelLine paLine1 = new PanelLine(ls1, le1, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine1);
        GuiTransform ls3 = new GuiTransform(GuiAlign.BOTTOM_LEFT, 174, -16, 0, 0, 0);
        ls3.setParent(cvBackground.getTransform());
        GuiTransform le3 = new GuiTransform(GuiAlign.BOTTOM_RIGHT, -16, -16, 0, 0, 0);
        le3.setParent(cvBackground.getTransform());
        PanelLine paLine3 = new PanelLine(ls3, le3, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine3);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        Minecraft mc = Minecraft.func_71410_x();
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            mc.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1 && btn instanceof PanelButtonStorage) {
            IQuestLine ql;
            for (PanelButtonStorage b : this.qlBtns) {
                if (b.getStoredValue() != this.selectedLine) continue;
                b.setActive(true);
                break;
            }
            this.selectedLine = ql = (IQuestLine)((PanelButtonStorage)btn).getStoredValue();
            this.selectedLineId = QuestLineDatabase.INSTANCE.getID(ql);
            this.cvQuest.setQuestLine(ql);
            this.paDesc.setText(QuestTranslation.translate(ql.getUnlocalisedDescription(), new Object[0]));
            this.cvDesc.refreshScrollBounds();
            this.scDesc.setEnabled(this.cvDesc.getScrollBounds().getHeight() > 0);
            btn.setActive(false);
        } else if (btn.getButtonID() == 2 && btn instanceof PanelButtonStorage) {
            IQuest quest = (IQuest)((PanelButtonStorage)btn).getStoredValue();
            GuiHome.bookmark = new GuiQuest(this, QuestDatabase.INSTANCE.getID(quest));
            this.lastScrollX = this.cvQuest.getScrollX();
            this.lastScrollY = this.cvQuest.getScrollY();
            this.lastZoom = this.cvQuest.getZoom();
            mc.func_147108_a(GuiHome.bookmark);
        } else if (btn.getButtonID() == 3) {
            mc.func_147108_a((GuiScreen)new GuiQuestLineEditorA(this));
        }
    }
}

