/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.misc;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.misc.IMultiCallback;
import betterquesting.api.utils.RenderUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiFileExplorer
extends GuiScreenThemed
implements IVolatileScreen {
    IMultiCallback<File> callback;
    File directory;
    File[] contents;
    FileFilter filter;
    boolean multiSelect = true;
    int leftScroll = 0;
    int rightScroll = 0;
    int maxRowsL = 0;
    int maxRowsR = 0;
    ArrayList<File> selected = new ArrayList();

    public GuiFileExplorer(GuiScreen parent, IMultiCallback<File> callback, File directory, FileFilter filter) {
        super(parent, directory.getAbsolutePath());
        this.callback = callback;
        this.directory = directory.getAbsoluteFile();
        this.filter = filter;
    }

    public GuiFileExplorer setSelected(ArrayList<File> prevSelect) {
        this.selected = prevSelect;
        return this;
    }

    public GuiFileExplorer setMultiSelect(boolean enabled) {
        this.multiSelect = enabled;
        return this;
    }

    @Override
    public void func_73866_w_() {
        GuiButtonThemed btn;
        int i;
        super.func_73866_w_();
        this.maxRowsL = (this.sizeY - 96) / 20;
        this.maxRowsR = (this.sizeY - 96) / 20;
        int btnWidth = this.sizeX / 2 - 16;
        int sx = this.sizeX - 32;
        this.field_146292_n.add(new GuiButtonThemed(1, this.guiLeft + 16 + sx / 4 * 3 - 50, this.guiTop + this.sizeY - 48, 100, 20, "...", true));
        for (i = 0; i < this.maxRowsL; ++i) {
            btn = new GuiButtonThemed(this.field_146292_n.size(), this.guiLeft + 16, this.guiTop + 48 + i * 20, btnWidth - 36, 20, "NULL", true);
            this.field_146292_n.add(btn);
        }
        for (i = 0; i < this.maxRowsL; ++i) {
            btn = new GuiButtonThemed(this.field_146292_n.size(), this.guiLeft + 16 + btnWidth - 36, this.guiTop + 48 + i * 20, 20, 20, "" + TextFormatting.RED + TextFormatting.BOLD + "x", true);
            this.field_146292_n.add(btn);
        }
        for (i = 0; i < this.maxRowsR; ++i) {
            btn = new GuiButtonThemed(this.field_146292_n.size(), this.guiLeft + this.sizeX / 2 + 28, this.guiTop + 48 + i * 20, btnWidth - 36, 20, "NULL", true);
            this.field_146292_n.add(btn);
        }
        for (i = 0; i < this.maxRowsR; ++i) {
            btn = new GuiButtonThemed(this.field_146292_n.size(), this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 48 + i * 20, 20, 20, "" + TextFormatting.GREEN + TextFormatting.BOLD + "<", true);
            this.field_146292_n.add(btn);
        }
        this.contents = this.directory.listFiles(this.filter);
        this.contents = this.contents != null ? this.contents : new File[]{};
        this.RefreshColumns();
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        int s;
        super.func_73863_a(mx, my, partialTick);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
        this.func_73729_b(this.guiLeft + this.sizeX / 2 - 16, this.guiTop + 48, 248, 0, 8, 20);
        for (s = 20; s < (this.maxRowsL - 1) * 20; s += 20) {
            this.func_73729_b(this.guiLeft + this.sizeX / 2 - 16, this.guiTop + 48 + s, 248, 20, 8, 20);
        }
        this.func_73729_b(this.guiLeft + this.sizeX / 2 - 16, this.guiTop + 48 + s, 248, 40, 8, 20);
        this.func_73729_b(this.guiLeft + this.sizeX / 2 - 16, this.guiTop + 48 + (int)Math.max(0.0f, (float)s * (float)this.leftScroll / (float)(this.selected.size() - this.maxRowsL)), 248, 60, 8, 20);
        this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48, 248, 0, 8, 20);
        for (s = 20; s < (this.maxRowsR - 1) * 20; s += 20) {
            this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48 + s, 248, 20, 8, 20);
        }
        this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48 + s, 248, 40, 8, 20);
        this.func_73729_b(this.guiLeft + this.sizeX - 24, this.guiTop + 48 + (int)Math.max(0.0f, (float)s * (float)this.rightScroll / (float)(this.contents.length - this.maxRowsL)), 248, 60, 8, 20);
        RenderUtils.DrawLine(this.field_146294_l / 2, this.guiTop + 32, this.field_146294_l / 2, this.guiTop + this.sizeY - 32, 2.0f, this.getTextColor());
        int sx = this.sizeX - 32;
        String txt = I18n.func_135052_a((String)"betterquesting.gui.selection", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_175065_a(txt, (float)(this.guiLeft + 16 + sx / 4 - this.field_146297_k.field_71466_p.func_78256_a(txt) / 2), (float)(this.guiTop + 32), this.getTextColor(), false);
        txt = I18n.func_135052_a((String)"betterquesting.gui.folder", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_175065_a(txt, (float)(this.guiLeft + 16 + sx / 4 * 3 - this.field_146297_k.field_71466_p.func_78256_a(txt) / 2), (float)(this.guiTop + 32), this.getTextColor(), false);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            if (this.callback != null) {
                this.callback.setValues((File[])this.selected.toArray(new File[0]));
            }
        } else if (button.field_146127_k == 1) {
            if (this.directory.getParentFile() != null) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiFileExplorer(this.parent, this.callback, this.directory.getParentFile(), this.filter).setSelected(this.selected));
            }
        } else if (button.field_146127_k > 1) {
            int n1 = button.field_146127_k - 2;
            int n2 = n1 / this.maxRowsL;
            int n3 = n1 % this.maxRowsL + this.leftScroll;
            int n4 = n1 % this.maxRowsL + this.rightScroll;
            if (n2 >= 2) {
                n2 = 2 + (n1 -= this.maxRowsL * 2) / this.maxRowsR;
                n4 = n1 % this.maxRowsR + this.rightScroll;
            }
            if (n2 != 0) {
                File f;
                if (n2 == 1) {
                    if (n3 >= 0 && n3 < this.selected.size()) {
                        this.selected.remove(n3);
                        this.RefreshColumns();
                    }
                } else if (n2 == 2) {
                    if (n4 >= 0 && n4 < this.contents.length) {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiFileExplorer(this.parent, this.callback, this.contents[n4], this.filter).setSelected(this.selected));
                    }
                } else if (n2 == 3 && n4 >= 0 && n4 < this.contents.length && (f = this.contents[n4]) != null) {
                    if (!this.multiSelect) {
                        this.selected.clear();
                    }
                    this.selected.add(f);
                    this.RefreshColumns();
                }
            }
        }
    }

    public void RefreshColumns() {
        this.leftScroll = Math.max(0, MathHelper.func_76125_a((int)this.leftScroll, (int)0, (int)(this.selected.size() - this.maxRowsL)));
        this.rightScroll = Math.max(0, MathHelper.func_76125_a((int)this.rightScroll, (int)0, (int)(this.contents.length - this.maxRowsR)));
        List btnList = this.field_146292_n;
        for (int i = 2; i < btnList.size(); ++i) {
            File f;
            GuiButton btn = (GuiButton)btnList.get(i);
            int n1 = i - 2;
            int n2 = n1 / this.maxRowsL;
            int n3 = n1 % this.maxRowsL + this.leftScroll;
            int n4 = n1 % this.maxRowsL + this.rightScroll;
            if (n2 >= 2) {
                n2 = 2 + (n1 -= this.maxRowsL * 2) / this.maxRowsR;
                n4 = n1 % this.maxRowsR + this.rightScroll;
            }
            if (n2 == 0) {
                if (n3 < 0 || n3 >= this.selected.size()) {
                    btn.field_146126_j = "NULL";
                    btn.field_146124_l = false;
                    btn.field_146125_m = false;
                    continue;
                }
                btn.field_146125_m = true;
                btn.field_146124_l = false;
                btn.field_146126_j = I18n.func_135052_a((String)this.selected.get(n3).getName(), (Object[])new Object[0]);
                continue;
            }
            if (n2 == 1) {
                btn.field_146124_l = n3 >= 0 && n3 < this.selected.size();
                btn.field_146125_m = btn.field_146124_l;
                continue;
            }
            if (n2 == 2) {
                if (n4 < 0 || n4 >= this.contents.length) {
                    btn.field_146126_j = "NULL";
                    btn.field_146124_l = false;
                    btn.field_146125_m = false;
                    continue;
                }
                f = this.contents[n4];
                btn.field_146125_m = true;
                btn.field_146124_l = f.isDirectory();
                btn.field_146126_j = f.getName();
                continue;
            }
            if (n2 != 3) continue;
            if (n4 < 0 || n4 >= this.contents.length) {
                btn.field_146124_l = false;
                btn.field_146125_m = false;
                continue;
            }
            f = this.contents[n4];
            btn.field_146125_m = !f.isDirectory();
            btn.field_146124_l = f != null && !f.isDirectory() && !this.selected.contains(f);
        }
    }

    @Override
    public void mouseScroll(int mx, int my, int scroll) {
        super.mouseScroll(mx, my, scroll);
        boolean refresh = false;
        if (scroll != 0 && this.isWithin(mx, my, this.guiLeft, this.guiTop, this.sizeX / 2, this.sizeY)) {
            this.leftScroll = Math.max(0, MathHelper.func_76125_a((int)(this.leftScroll + scroll), (int)0, (int)(this.selected.size() - this.maxRowsL)));
            refresh = true;
        }
        if (scroll != 0 && this.isWithin(mx, my, this.guiLeft + this.sizeX / 2, this.guiTop, this.sizeX / 2, this.sizeY)) {
            this.rightScroll = Math.max(0, MathHelper.func_76125_a((int)(this.rightScroll + scroll), (int)0, (int)(this.contents.length - this.maxRowsR)));
            refresh = true;
        }
        if (refresh) {
            this.RefreshColumns();
        }
    }
}

