/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.inventory;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.IFluidTask;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.QuestCache;
import betterquesting.api2.storage.DBEntry;
import betterquesting.blocks.TileSubmitStation;
import betterquesting.client.gui.inventory.ContainerSubmitStation;
import betterquesting.client.gui.inventory.GuiContainerThemed;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.text.TextFormatting;

public class GuiSubmitStation
extends GuiContainerThemed
implements INeedsRefresh {
    private final TileSubmitStation tile;
    private final List<IQuest> activeQuests = new ArrayList<IQuest>();
    private int selQuest = 0;
    private int selTask = 0;
    private IQuest quest;
    private ITask task;
    private IGuiEmbedded taskUI;
    private GuiButtonThemed btnSelect;
    private GuiButtonThemed btnRemove;
    private ContainerSubmitStation subContainer = (ContainerSubmitStation)this.inventorySlots;

    public GuiSubmitStation(GuiScreen parent, InventoryPlayer invo, TileSubmitStation tile) {
        super(parent, "betterquesting.title.submit_station", new ContainerSubmitStation(invo, tile));
        this.tile = tile;
        this.setMaxSize(500, 300);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.tile == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        this.activeQuests.clear();
        UUID pID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        QuestCache.INSTANCE.updateCache((EntityPlayer)this.field_146297_k.field_71439_g);
        this.activeQuests.addAll(QuestCache.INSTANCE.getActiveQuests(pID));
        Iterator<IQuest> qit = this.activeQuests.iterator();
        while (qit.hasNext()) {
            IQuest q = qit.next();
            if (q.getProperties().getProperty(NativeProps.VISIBILITY) != EnumQuestVisibility.HIDDEN) continue;
            qit.remove();
        }
        this.field_146292_n.add(new GuiButtonThemed(1, this.guiLeft + this.sizeX / 2 - 120, this.guiTop + 32, 20, 20, "<", true));
        this.field_146292_n.add(new GuiButtonThemed(2, this.guiLeft + this.sizeX / 2 + 100, this.guiTop + 32, 20, 20, ">", true));
        this.field_146292_n.add(new GuiButtonThemed(3, this.guiLeft + this.sizeX / 2 - 120, this.guiTop + 52, 20, 20, "<", true));
        this.field_146292_n.add(new GuiButtonThemed(4, this.guiLeft + this.sizeX / 2 + 100, this.guiTop + 52, 20, 20, ">", true));
        this.btnSelect = new GuiButtonThemed(5, this.guiLeft + this.sizeX / 2 - 20, this.guiTop + 72, 20, 20, TextFormatting.GREEN + "\u2714", true);
        this.btnRemove = new GuiButtonThemed(6, this.guiLeft + this.sizeX / 2 + 0, this.guiTop + 72, 20, 20, TextFormatting.RED + "x", true);
        this.field_146292_n.add(this.btnSelect);
        this.field_146292_n.add(this.btnRemove);
        int invX = 16 + (this.sizeX / 2 - 24) / 2 - 81;
        int invY = 92 + (this.sizeY - 108) / 2 - 49 + 22;
        this.subContainer.moveInventorySlots(invX + 1, invY + 1);
        this.subContainer.moveSubmitSlot((invX += 54) + 1, (invY -= 22) + 1);
        this.subContainer.moveReturnSlot((invX += 36) + 1, invY + 1);
        this.RefreshValues();
    }

    @Override
    public void refreshGui() {
        this.func_73866_w_();
    }

    @Override
    public void drawBackPanel(int mx, int my, float partialTick) {
        super.drawBackPanel(mx, my, partialTick);
        this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
        int invX = this.guiLeft + 16 + (this.sizeX / 2 - 24) / 2 - 81;
        int invY = this.guiTop + 92 + (this.sizeY - 108) / 2 - 49 + 22;
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 9; ++i) {
                this.func_73729_b(i * 18 + invX, j * 18 + invY, 0, 48, 18, 18);
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.func_73729_b(i * 18 + invX, 58 + invY, 0, 48, 18, 18);
        }
        this.func_73729_b(invX += 54, invY -= 22, 0, 48, 18, 18);
        this.func_73729_b(invX += 36, invY, 0, 48, 18, 18);
        this.field_146297_k.field_71466_p.func_175065_a("-->", (float)(invX - 17), (float)(invY + 7), Color.BLACK.getRGB(), false);
        this.field_146297_k.field_71466_p.func_175065_a("-->", (float)(invX - 17), (float)(invY + 6), this.getTextColor(), false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.quest != null) {
            this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)this.quest.getUnlocalisedName(), (Object[])new Object[0]), (float)(this.guiLeft + this.sizeX / 2 - 92), (float)(this.guiTop + 40), this.getTextColor(), false);
        }
        if (this.task != null) {
            this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)this.task.getUnlocalisedName(), (Object[])new Object[0]), (float)(this.guiLeft + this.sizeX / 2 - 92), (float)(this.guiTop + 60), this.getTextColor(), false);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTick, int mx, int my) {
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 1) {
            this.selQuest = this.activeQuests.size() > 0 ? this.PositiveModulo(this.selQuest - 1, this.activeQuests.size()) : 0;
            this.RefreshValues();
        } else if (button.field_146127_k == 2) {
            this.selQuest = this.activeQuests.size() > 0 ? this.PositiveModulo(this.selQuest + 1, this.activeQuests.size()) : 0;
            this.RefreshValues();
        } else if (button.field_146127_k == 3) {
            this.selTask = this.quest != null && this.quest.getTasks().size() > 0 ? this.PositiveModulo(this.selTask - 1, this.quest.getTasks().size()) : 0;
            this.RefreshValues();
        } else if (button.field_146127_k == 4) {
            this.selTask = this.quest != null && this.quest.getTasks().size() > 0 ? this.PositiveModulo(this.selTask + 1, this.quest.getTasks().size()) : 0;
            this.RefreshValues();
        } else if (button.field_146127_k == 5) {
            this.tile.setupTask(QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g), this.quest, this.task);
            this.tile.SyncTile(null);
            this.RefreshValues();
        } else if (button.field_146127_k == 6) {
            this.tile.reset();
            this.tile.SyncTile(null);
            this.RefreshValues();
        }
    }

    public void RefreshValues() {
        this.embedded.remove(this.taskUI);
        if (this.tile.getRawTask() != null) {
            this.quest = this.tile.getQuest();
            this.task = this.tile.getRawTask();
            this.taskUI = this.task.getTaskGui(this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 92, this.sizeX / 2 - 24, this.sizeY - 92 - 16, this.quest);
            if (this.taskUI != null) {
                this.embedded.add(this.taskUI);
            }
            this.selQuest = Math.max(0, this.activeQuests.indexOf(this.quest));
            this.selTask = Math.max(0, GuiSubmitStation.indexOfTask(this.quest, this.task));
            for (int i = 1; i <= 4; ++i) {
                ((GuiButton)this.field_146292_n.get((int)i)).field_146124_l = false;
            }
            this.btnSelect.field_146124_l = false;
            this.btnRemove.field_146124_l = true;
            return;
        }
        for (int i = 1; i <= 4; ++i) {
            ((GuiButton)this.field_146292_n.get((int)i)).field_146124_l = true;
        }
        this.btnRemove.field_146124_l = false;
        if (this.selQuest < 0 || this.selQuest >= this.activeQuests.size()) {
            this.quest = null;
            this.task = null;
        } else {
            this.quest = this.activeQuests.get(this.selQuest);
        }
        this.task = this.quest == null || this.selTask < 0 || this.selTask >= this.quest.getTasks().size() ? null : (ITask)this.quest.getTasks().getEntries()[this.selTask].getValue();
        if (this.task == null) {
            this.taskUI = null;
        } else {
            this.taskUI = this.task.getTaskGui(this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 92, this.sizeX / 2 - 24, this.sizeY - 92 - 16, this.quest);
            if (this.taskUI != null) {
                this.embedded.add(this.taskUI);
            }
        }
        this.btnSelect.field_146124_l = (this.task instanceof IFluidTask || this.task instanceof IItemTask) && !this.task.isComplete(QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g));
    }

    int PositiveModulo(int value, int mod) {
        return (value % mod + mod) % mod;
    }

    private static int indexOfTask(IQuest quest, ITask task) {
        DBEntry<T>[] db = quest.getTasks().getEntries();
        for (int i = 0; i < db.length; ++i) {
            if (db[i].getValue() != task) continue;
            return i;
        }
        return -1;
    }
}

