/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.rewards;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingButtons;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.misc.IFactory;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.gui.editors.rewards.GuiRewardEditDefault;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.rewards.RewardRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiRewardEditor
extends GuiScreenThemed
implements IVolatileScreen,
INeedsRefresh {
    private List<IFactory<? extends IReward>> rewardTypes = new ArrayList<IFactory<? extends IReward>>();
    private DBEntry<IReward>[] rewardIDs = new DBEntry[0];
    private IQuest quest;
    private int qID;
    private GuiScrollingButtons btnsLeft;
    private GuiScrollingButtons btnsRight;

    public GuiRewardEditor(GuiScreen parent, IQuest quest) {
        super(parent, I18n.func_135052_a((String)"betterquesting.title.edit_rewards", (Object[])new Object[]{I18n.func_135052_a((String)quest.getUnlocalisedName(), (Object[])new Object[0])}));
        this.quest = quest;
        this.qID = QuestDatabase.INSTANCE.getID(quest);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.rewardTypes = RewardRegistry.INSTANCE.getAll();
        this.rewardIDs = this.quest.getRewards().getEntries();
        this.btnsLeft = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + 16, this.guiTop + 32, this.sizeX / 2 - 24, this.sizeY - 64);
        this.btnsRight = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 32, this.sizeX / 2 - 24, this.sizeY - 64);
        this.embedded.add(this.btnsLeft);
        this.embedded.add(this.btnsRight);
        this.RefreshColumns();
    }

    @Override
    public void refreshGui() {
        IQuest tmp = (IQuest)QuestDatabase.INSTANCE.getValue(this.qID);
        if (tmp == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        this.quest = tmp;
        this.rewardIDs = this.quest.getRewards().getEntries();
        this.RefreshColumns();
    }

    @Override
    public void drawBackPanel(int mx, int my, float partialTick) {
        super.drawBackPanel(mx, my, partialTick);
        RenderUtils.DrawLine(this.field_146294_l / 2, this.guiTop + 32, this.field_146294_l / 2, this.guiTop + this.sizeY - 32, 2.0f, this.getTextColor());
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        int column = button.field_146127_k & 3;
        int id = (button.field_146127_k >> 2) - 1;
        if (id < 0) {
            return;
        }
        if (column == 0) {
            IReward reward = (IReward)this.quest.getRewards().getValue(id);
            if (reward != null) {
                GuiScreen editor = reward.getRewardEditor(this, this.quest);
                if (editor != null) {
                    this.field_146297_k.func_147108_a(editor);
                } else {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiRewardEditDefault(this, this.quest, reward));
                }
            }
        } else if (column == 1) {
            this.quest.getRewards().removeID(id);
            this.SendChanges();
        } else if (column == 2 && id >= 0 && id < this.rewardTypes.size()) {
            this.quest.getRewards().add(this.quest.getRewards().nextID(), RewardRegistry.INSTANCE.createReward(this.rewardTypes.get(id).getRegistryName()));
            this.SendChanges();
        }
    }

    public void func_73864_a(int mx, int my, int click) throws IOException {
        super.func_73864_a(mx, my, click);
        if (click != 0) {
            return;
        }
        GuiButtonThemed btn1 = this.btnsLeft.getButtonUnderMouse(mx, my);
        if (btn1 != null && btn1.func_146116_c(this.field_146297_k, mx, my)) {
            btn1.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(btn1);
            return;
        }
        GuiButtonThemed btn2 = this.btnsRight.getButtonUnderMouse(mx, my);
        if (btn2 != null && btn2.func_146116_c(this.field_146297_k, mx, my)) {
            btn2.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(btn2);
            return;
        }
    }

    public void SendChanges() {
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("config", (NBTBase)this.quest.writeToNBT(new NBTTagCompound(), EnumSaveType.CONFIG));
        base.func_74782_a("progress", (NBTBase)this.quest.writeToNBT(new NBTTagCompound(), EnumSaveType.PROGRESS));
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
        tags.func_74768_a("questID", QuestDatabase.INSTANCE.getID(this.quest));
        tags.func_74782_a("data", (NBTBase)base);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tags));
    }

    public void RefreshColumns() {
        this.btnsLeft.getEntryList().clear();
        this.btnsRight.getEntryList().clear();
        for (DBEntry<IReward> entry : this.rewardIDs) {
            int btnWidth = this.btnsLeft.getListWidth();
            int bID = 1 + entry.getID() << 2;
            GuiButtonThemed btn1 = new GuiButtonThemed(bID + 0, 0, 0, btnWidth - 20, 20, I18n.func_135052_a((String)((IReward)this.quest.getRewards().getValue(entry.getID())).getUnlocalisedName(), (Object[])new Object[0]));
            GuiButtonThemed btn2 = new GuiButtonThemed(bID + 1, 0, 0, 20, 20, "" + TextFormatting.RED + TextFormatting.BOLD + "x");
            this.btnsLeft.addButtonRow(btn1, btn2);
        }
        for (int i = 0; i < this.rewardTypes.size(); ++i) {
            int btnWidth = this.btnsRight.getListWidth();
            int bID = 1 + i << 2;
            GuiButtonThemed btn1 = new GuiButtonThemed(bID + 2, 0, 0, btnWidth, 20, this.rewardTypes.get(i).getRegistryName().toString());
            this.btnsRight.addButtonRow(btn1);
        }
    }
}

