/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors.rewards;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.misc.ICallback;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.client.gui2.editors.nbt.GuiNbtEditor;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GuiRewardEditDefault
extends GuiScreenThemed
implements ICallback<NBTTagCompound> {
    private final IQuest quest;
    private final int qID;
    private final int rID;
    private final NBTTagCompound json;
    private boolean isDone;

    public GuiRewardEditDefault(GuiScreen parent, IQuest quest, IReward reward) {
        super(parent, reward.getUnlocalisedName());
        this.quest = quest;
        this.qID = QuestDatabase.INSTANCE.getID(quest);
        this.rID = quest.getRewards().getID(reward);
        this.json = reward.writeToNBT(new NBTTagCompound(), EnumSaveType.CONFIG);
        this.isDone = false;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.isDone) {
            this.isDone = true;
            IReward reward = (IReward)this.quest.getRewards().getValue(this.rID);
            if (reward != null) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNbtEditor((GuiScreen)this, this.json, this));
            } else {
                this.field_146297_k.func_147108_a(this.parent);
            }
        } else {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    @Override
    public void setValue(NBTTagCompound value) {
        IReward reward = (IReward)this.quest.getRewards().getValue(this.rID);
        if (reward != null) {
            reward.readFromNBT(value, EnumSaveType.CONFIG);
            this.SendChanges();
        }
    }

    public void SendChanges() {
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("config", (NBTBase)this.quest.writeToNBT(new NBTTagCompound(), EnumSaveType.CONFIG));
        base.func_74782_a("progress", (NBTBase)this.quest.writeToNBT(new NBTTagCompound(), EnumSaveType.PROGRESS));
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
        tags.func_74768_a("questID", this.qID);
        tags.func_74782_a("data", (NBTBase)base);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tags));
    }
}

