/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiBigTextField;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingButtons;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.QuestLineEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiQuestLineEditorB
extends GuiScreenThemed
implements IVolatileScreen,
INeedsRefresh {
    private int lineID = -1;
    private IQuestLine line;
    GuiBigTextField searchBox;
    List<Integer> searchResults = new ArrayList<Integer>();
    DBEntry<IQuestLineEntry>[] lineQuests = new DBEntry[0];
    private GuiScrollingButtons dbBtnList;
    private GuiScrollingButtons qlBtnList;

    public GuiQuestLineEditorB(GuiScreen parent, IQuestLine line) {
        super(parent, I18n.func_135052_a((String)"betterquesting.title.edit_line2", (Object[])new Object[]{line == null ? "?" : I18n.func_135052_a((String)line.getUnlocalisedName(), (Object[])new Object[0])}));
        this.line = line;
        this.lineID = QuestLineDatabase.INSTANCE.getID(line);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int btnWidth = this.sizeX / 2 - 16;
        int sx = this.sizeX - 32;
        this.searchBox = new GuiBigTextField(this.field_146297_k.field_71466_p, this.guiLeft + this.sizeX / 2 + 9, this.guiTop + 49, btnWidth - 18, 18);
        this.searchBox.setWatermark(I18n.func_135052_a((String)"betterquesting.gui.search", (Object[])new Object[0]));
        this.field_146292_n.add(new GuiButtonThemed(1, this.guiLeft + 16 + sx / 4 * 3 - 50, this.guiTop + this.sizeY - 48, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.new", (Object[])new Object[0]), true));
        this.qlBtnList = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + 16, this.guiTop + 48, btnWidth - 8, this.sizeY - 96);
        this.dbBtnList = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 68, btnWidth - 8, this.sizeY - 116);
        this.embedded.add(this.qlBtnList);
        this.embedded.add(this.dbBtnList);
        this.RefreshSearch();
        this.RefreshColumns();
    }

    @Override
    public void refreshGui() {
        this.line = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(this.lineID);
        if (this.lineID >= 0 && this.line == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        this.setTitle(I18n.func_135052_a((String)"betterquesting.title.edit_line2", (Object[])new Object[]{this.line == null ? "?" : I18n.func_135052_a((String)this.line.getUnlocalisedName(), (Object[])new Object[0])}));
        this.RefreshSearch();
        this.RefreshColumns();
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        super.func_73863_a(mx, my, partialTick);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.currentTheme().getGuiTexture());
        RenderUtils.DrawLine(this.field_146294_l / 2, this.guiTop + 32, this.field_146294_l / 2, this.guiTop + this.sizeY - 32, 2.0f, this.getTextColor());
        int sx = this.sizeX - 32;
        String txt = I18n.func_135052_a((String)"betterquesting.gui.quest_line", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_175065_a(txt, (float)(this.guiLeft + 16 + sx / 4 - this.field_146297_k.field_71466_p.func_78256_a(txt) / 2), (float)(this.guiTop + 32), this.getTextColor(), false);
        txt = I18n.func_135052_a((String)"betterquesting.gui.database", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_175065_a(txt, (float)(this.guiLeft + 16 + sx / 4 * 3 - this.field_146297_k.field_71466_p.func_78256_a(txt) / 2), (float)(this.guiTop + 32), this.getTextColor(), false);
        this.searchBox.drawTextBox(mx, my, partialTick);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 1) {
            this.createQuest();
        } else if (button.field_146127_k > 1) {
            int column = button.field_146127_k & 7;
            int id = (button.field_146127_k >> 3) - 2;
            if (column == 0 || column == 3) {
                IQuest q;
                if (id >= 0 && (q = (IQuest)QuestDatabase.INSTANCE.getValue(id)) != null) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiQuest(this, id));
                }
            } else if (column == 1 && this.line != null) {
                this.line.removeID(id);
                this.SendChanges(EnumPacketAction.EDIT, this.lineID);
            } else if (column == 4 && id >= 0) {
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74768_a("action", EnumPacketAction.REMOVE.ordinal());
                tags.func_74768_a("questID", id);
                PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tags));
            } else if (column == 2 && this.line != null && id >= 0) {
                QuestLineEntry qe = new QuestLineEntry(0, 0);
                int x1 = 0;
                int y1 = 0;
                while (true) {
                    for (DBEntry qe2 : this.line.getEntries()) {
                        int x2 = ((IQuestLineEntry)qe2.getValue()).getPosX();
                        int y2 = ((IQuestLineEntry)qe2.getValue()).getPosY();
                        int s2 = ((IQuestLineEntry)qe2.getValue()).getSize();
                        if (x1 < x2 || x1 >= x2 + s2 || y1 < y2 || y1 >= y2 + s2) continue;
                        x1 += s2;
                        x2 += s2;
                    }
                    break;
                }
                qe.setPosition(x1, y1);
                this.line.add(id, qe);
                this.RefreshColumns();
                this.SendChanges(EnumPacketAction.EDIT, this.lineID);
            }
        }
    }

    public void createQuest() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("action", EnumPacketAction.ADD.ordinal());
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tag));
    }

    public void SendChanges(EnumPacketAction action, int lineID) {
        if (action == null) {
            return;
        }
        NBTTagCompound tags = new NBTTagCompound();
        if (action == EnumPacketAction.EDIT && this.line != null) {
            NBTTagCompound base = new NBTTagCompound();
            base.func_74782_a("line", (NBTBase)this.line.writeToNBT(new NBTTagCompound(), EnumSaveType.CONFIG));
            tags.func_74782_a("data", (NBTBase)base);
        }
        tags.func_74768_a("action", action.ordinal());
        tags.func_74768_a("lineID", QuestLineDatabase.INSTANCE.getID(this.line));
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.LINE_EDIT.GetLocation(), tags));
    }

    public void RefreshColumns() {
        this.lineQuests = this.line == null ? new DBEntry[0] : this.line.getEntries();
        this.qlBtnList.getEntryList().clear();
        for (DBEntry<IQuestLineEntry> qID : this.lineQuests) {
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(qID.getID());
            if (quest == null) continue;
            int bWidth = this.qlBtnList.getListWidth();
            int bID = 2 + qID.getID() << 3;
            GuiButtonThemed btn1 = new GuiButtonThemed(bID + 0, 0, 0, bWidth - 20, 20, I18n.func_135052_a((String)quest.getUnlocalisedName(), (Object[])new Object[0]));
            GuiButtonThemed btn2 = new GuiButtonThemed(bID + 1, 0, 0, 20, 20, TextFormatting.YELLOW + ">");
            this.qlBtnList.addButtonRow(btn1, btn2);
        }
        this.dbBtnList.getEntryList().clear();
        Iterator<Integer> iterator = this.searchResults.iterator();
        while (iterator.hasNext()) {
            int qID = (Integer)iterator.next();
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(qID);
            if (quest == null) continue;
            int bWidth = this.dbBtnList.getListWidth();
            int bID = 2 + qID << 3;
            GuiButtonThemed btn3 = new GuiButtonThemed(bID + 2, 0, 0, 20, 20, TextFormatting.GREEN + "<");
            btn3.field_146124_l = this.line != null && this.line.getValue(qID) == null;
            GuiButtonThemed btn4 = new GuiButtonThemed(bID + 3, 0, 0, bWidth - 40, 20, I18n.func_135052_a((String)quest.getUnlocalisedName(), (Object[])new Object[0]));
            GuiButtonThemed btn5 = new GuiButtonThemed(bID + 4, 0, 0, 20, 20, "" + TextFormatting.BOLD + TextFormatting.RED + "x");
            this.dbBtnList.addButtonRow(btn3, btn4, btn5);
        }
    }

    @Override
    protected void func_73869_a(char character, int num) throws IOException {
        super.func_73869_a(character, num);
        String prevTxt = this.searchBox.func_146179_b();
        this.searchBox.func_146201_a(character, num);
        if (!this.searchBox.func_146179_b().equalsIgnoreCase(prevTxt)) {
            this.RefreshSearch();
            this.RefreshColumns();
        }
    }

    public void RefreshSearch() {
        this.searchResults.clear();
        String query = this.searchBox.func_146179_b().toLowerCase();
        for (DBEntry entry : QuestDatabase.INSTANCE.getEntries()) {
            IQuest q = (IQuest)entry.getValue();
            if (query.length() > 0 && !q.getUnlocalisedName().toLowerCase().contains(query) && !I18n.func_135052_a((String)q.getUnlocalisedName(), (Object[])new Object[0]).toLowerCase().contains(query) && !query.equalsIgnoreCase("" + entry.getID())) continue;
            this.searchResults.add(entry.getID());
        }
    }

    public void func_73864_a(int mx, int my, int type) throws IOException {
        super.func_73864_a(mx, my, type);
        this.searchBox.func_146192_a(mx, my, type);
        if (type != 0) {
            return;
        }
        GuiButtonThemed btn1 = this.qlBtnList.getButtonUnderMouse(mx, my);
        if (btn1 != null && btn1.func_146116_c(this.field_146297_k, mx, my)) {
            btn1.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(btn1);
            return;
        }
        GuiButtonThemed btn2 = this.dbBtnList.getButtonUnderMouse(mx, my);
        if (btn2 != null && btn2.func_146116_c(this.field_146297_k, mx, my)) {
            btn2.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(btn2);
            return;
        }
    }
}

