/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiBigTextField;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingButtons;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.misc.ICallback;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.gui.editors.GuiImporters;
import betterquesting.client.gui.editors.GuiQuestLineDesigner;
import betterquesting.client.gui.editors.GuiQuestLineEditorB;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestLineDatabase;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiQuestLineEditorA
extends GuiScreenThemed
implements ICallback<String>,
IVolatileScreen,
INeedsRefresh {
    private DBEntry<IQuestLine>[] questList = new DBEntry[0];
    private GuiButtonThemed btnDesign;
    private GuiTextField lineTitle;
    private GuiBigTextField lineDesc;
    private IQuestLine selected;
    int selID = -1;
    private GuiScrollingButtons btnList;

    public GuiQuestLineEditorA(GuiScreen parent) {
        super(parent, "betterquesting.title.edit_line1");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int btnWidth = this.sizeX / 2 - 16;
        int sx = this.sizeX - 32;
        this.lineTitle = new GuiTextField(0, this.field_146297_k.field_71466_p, this.guiLeft + this.sizeX / 2 + 9, this.guiTop + this.sizeY / 2 - 59, btnWidth - 18, 18);
        this.lineTitle.func_146203_f(Integer.MAX_VALUE);
        this.lineDesc = new GuiBigTextField(this.field_146297_k.field_71466_p, this.guiLeft + this.sizeX / 2 + 9, this.guiTop + this.sizeY / 2 - 19, btnWidth - 18, 18).enableBigEdit(this);
        this.lineDesc.func_146203_f(Integer.MAX_VALUE);
        this.field_146292_n.add(new GuiButtonThemed(1, this.guiLeft + 16, this.guiTop + this.sizeY - 48, (btnWidth - 16) / 2, 20, I18n.func_135052_a((String)"betterquesting.btn.new", (Object[])new Object[0]), true));
        GuiButtonThemed btnImport = new GuiButtonThemed(3, this.guiLeft + 16 + (btnWidth - 16) / 2, this.guiTop + this.sizeY - 48, (btnWidth - 16) / 2, 20, I18n.func_135052_a((String)"betterquesting.btn.import", (Object[])new Object[0]), true);
        this.field_146292_n.add(btnImport);
        this.field_146292_n.add(new GuiButtonThemed(2, this.guiLeft + 16 + sx / 4 * 3 - 75, this.guiTop + this.sizeY / 2 + 20, 150, 20, I18n.func_135052_a((String)"betterquesting.btn.add_remove_quests", (Object[])new Object[0]), true));
        this.btnDesign = new GuiButtonThemed(4, this.guiLeft + 16 + sx / 4 * 3 - 75, this.guiTop + this.sizeY / 2 + 40, 150, 20, I18n.func_135052_a((String)"betterquesting.btn.designer", (Object[])new Object[0]), true);
        this.field_146292_n.add(this.btnDesign);
        this.btnList = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + 16, this.guiTop + 32, btnWidth - 8, this.sizeY - 80);
        this.embedded.add(this.btnList);
        if (this.selected != null) {
            this.lineTitle.func_146180_a(this.selected.getUnlocalisedName());
            this.lineDesc.func_146180_a(this.selected.getUnlocalisedDescription());
        }
        this.RefreshColumns();
    }

    @Override
    public void refreshGui() {
        this.selected = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(this.selID);
        if (this.selected != null) {
            this.lineTitle.func_146180_a(this.selected.getUnlocalisedName());
            this.lineDesc.func_146180_a(this.selected.getUnlocalisedDescription());
        }
        this.RefreshColumns();
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        super.func_73863_a(mx, my, partialTick);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.DrawLine(this.field_146294_l / 2, this.guiTop + 32, this.field_146294_l / 2, this.guiTop + this.sizeY - 48, 2.0f, this.getTextColor());
        this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)"betterquesting.gui.name", (Object[])new Object[0]), (float)(this.guiLeft + this.sizeX / 2 + 8), (float)(this.guiTop + this.sizeY / 2 - 72), this.getTextColor(), false);
        this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)"betterquesting.gui.description", (Object[])new Object[0]), (float)(this.guiLeft + this.sizeX / 2 + 8), (float)(this.guiTop + this.sizeY / 2 - 32), this.getTextColor(), false);
        this.lineTitle.func_146194_f();
        this.lineDesc.drawTextBox(mx, my, partialTick);
    }

    public void DeleteQuest(int id) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("action", 1);
        tags.func_74768_a("questID", id);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tags));
    }

    public void SendChanges(EnumPacketAction action, IQuestLine questLine) {
        this.SendChanges(action, QuestLineDatabase.INSTANCE.getID(questLine));
    }

    public void SendChanges(EnumPacketAction action, int lineID) {
        this.SendChanges(action, lineID, QuestLineDatabase.INSTANCE.getOrderIndex(lineID));
    }

    public void SendChanges(EnumPacketAction action, int lineID, int order) {
        IQuestLine questLine = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(lineID);
        if (action == null) {
            return;
        }
        NBTTagCompound tags = new NBTTagCompound();
        if (action == EnumPacketAction.EDIT && questLine != null) {
            NBTTagCompound base = new NBTTagCompound();
            base.func_74782_a("line", (NBTBase)questLine.writeToNBT(new NBTTagCompound(), EnumSaveType.CONFIG));
            tags.func_74782_a("data", (NBTBase)base);
        }
        tags.func_74768_a("lineID", questLine == null ? -1 : QuestLineDatabase.INSTANCE.getID(questLine));
        tags.func_74768_a("order", order);
        tags.func_74768_a("action", action.ordinal());
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.LINE_EDIT.GetLocation(), tags));
    }

    @Override
    public void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (btn.field_146127_k == 1) {
            this.SendChanges(EnumPacketAction.ADD, -1);
            this.RefreshColumns();
        } else if (btn.field_146127_k == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestLineEditorB((GuiScreen)this, this.selected));
        } else if (btn.field_146127_k == 3) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiImporters(this));
        } else if (btn.field_146127_k == 4 && this.selected != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestLineDesigner((GuiScreen)this, this.selected));
        } else if (btn.field_146127_k > 4) {
            int order;
            int n2 = btn.field_146127_k & 3;
            int n3 = (btn.field_146127_k >> 2) - 5;
            if (n2 == 0) {
                if (n3 >= 0) {
                    this.selected = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(n3);
                    this.selID = n3;
                    if (this.selected != null) {
                        this.lineTitle.func_146180_a(this.selected.getUnlocalisedName());
                        this.lineDesc.func_146180_a(this.selected.getUnlocalisedDescription());
                    }
                } else {
                    this.selected = null;
                    this.selID = -1;
                }
                this.RefreshColumns();
            } else if (n2 == 1) {
                if (n3 >= 0) {
                    this.SendChanges(EnumPacketAction.REMOVE, n3);
                }
            } else if (n2 == 2 && n3 >= 0 && (order = QuestLineDatabase.INSTANCE.getOrderIndex(n3)) > 0) {
                this.SendChanges(EnumPacketAction.EDIT, n3, order - 1);
            }
        }
    }

    @Override
    protected void func_73869_a(char character, int keyCode) throws IOException {
        super.func_73869_a(character, keyCode);
        if (this.selected != null) {
            this.lineDesc.func_146201_a(character, keyCode);
            this.lineTitle.func_146201_a(character, keyCode);
            if (keyCode == 28) {
                boolean flag = false;
                if (this.lineTitle.func_146206_l()) {
                    if (!this.lineTitle.func_146179_b().equals(this.selected.getUnlocalisedName())) {
                        this.selected.getProperties().setProperty(NativeProps.NAME, this.lineTitle.func_146179_b());
                        flag = true;
                    }
                    this.lineTitle.func_146195_b(false);
                }
                if (this.lineDesc.func_146206_l()) {
                    if (!this.lineDesc.func_146179_b().equals(this.selected.getUnlocalisedDescription())) {
                        this.selected.getProperties().setProperty(NativeProps.DESC, this.lineDesc.func_146179_b());
                        flag = true;
                    }
                    this.lineDesc.func_146195_b(false);
                }
                if (flag) {
                    this.SendChanges(EnumPacketAction.EDIT, this.selected);
                }
            }
        }
    }

    protected void func_73864_a(int mx, int my, int click) throws IOException {
        GuiButtonThemed btn;
        this.lineTitle.func_146192_a(mx, my, click);
        this.lineDesc.func_146192_a(mx, my, click);
        if (this.selected != null) {
            boolean flag = false;
            if (!this.lineTitle.func_146206_l() && !this.lineTitle.func_146179_b().equals(this.selected.getUnlocalisedName())) {
                this.selected.getProperties().setProperty(NativeProps.NAME, this.lineTitle.func_146179_b());
                flag = true;
            }
            if (!this.lineDesc.func_146206_l() && !this.lineDesc.func_146179_b().equals(this.selected.getUnlocalisedDescription())) {
                this.selected.getProperties().setProperty(NativeProps.DESC, this.lineDesc.func_146179_b());
                flag = true;
            }
            if (flag) {
                this.SendChanges(EnumPacketAction.EDIT, this.selected);
            }
        }
        super.func_73864_a(mx, my, click);
        GuiButtonThemed guiButtonThemed = btn = click != 0 ? null : this.btnList.getButtonUnderMouse(mx, my);
        if (btn != null && btn.func_146116_c(this.field_146297_k, mx, my)) {
            btn.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(btn);
        }
    }

    public void RefreshColumns() {
        this.questList = QuestLineDatabase.INSTANCE.getSortedEntries();
        if (this.btnDesign != null) {
            this.btnDesign.field_146124_l = this.selected != null;
        }
        this.btnList.getEntryList().clear();
        for (DBEntry<IQuestLine> qlid : this.questList) {
            int bWidth = this.btnList.getListWidth();
            int bID = 5 + qlid.getID() << 2;
            GuiButtonThemed btn1 = new GuiButtonThemed(bID + 0, 0, 0, bWidth - 40, 20, I18n.func_135052_a((String)qlid.getValue().getUnlocalisedName(), (Object[])new Object[0]));
            btn1.field_146124_l = qlid.getValue() != this.selected;
            GuiButtonThemed btn2 = new GuiButtonThemed(bID + 1, 0, 0, 20, 20, "" + TextFormatting.RED + TextFormatting.BOLD + "x");
            GuiButtonThemed btn3 = new GuiButtonThemed(bID + 2, 0, 0, 20, 20, "" + TextFormatting.YELLOW + TextFormatting.BOLD + "^");
            this.btnList.addButtonRow(btn1, btn2, btn3);
        }
    }

    @Override
    public void setValue(String text) {
        if (this.lineDesc != null) {
            this.lineDesc.func_146180_a(text);
        }
        if (this.selected != null) {
            this.selected.getProperties().setProperty(NativeProps.DESC, text);
            this.SendChanges(EnumPacketAction.EDIT, this.selected);
        }
    }
}

