/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui.editors;

import betterquesting.api.client.gui.GuiScreenThemed;
import betterquesting.api.client.gui.controls.GuiButtonStorage;
import betterquesting.api.client.gui.controls.GuiButtonThemed;
import betterquesting.api.client.gui.lists.GuiScrollingButtons;
import betterquesting.api.client.gui.misc.IGuiEmbedded;
import betterquesting.api.client.importers.IImporter;
import betterquesting.api.enums.EnumSaveType;
import betterquesting.api.misc.IMultiCallback;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.utils.RenderUtils;
import betterquesting.client.gui.editors.GuiImporterEmbedded;
import betterquesting.client.gui.misc.GuiFileExplorer;
import betterquesting.client.importers.ImportedQuestLines;
import betterquesting.client.importers.ImportedQuests;
import betterquesting.client.importers.ImporterRegistry;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GuiImporters
extends GuiScreenThemed
implements IMultiCallback<File> {
    private GuiScrollingButtons btnList;
    private IGuiEmbedded impGui = null;
    private IImporter selected = null;

    public GuiImporters(GuiScreen parent) {
        super(parent, "betterquesting.title.importers");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.btnList = new GuiScrollingButtons(this.field_146297_k, this.guiLeft + 16, this.guiTop + 32, this.sizeX / 2 - 24, this.sizeY - 64);
        for (IImporter imp : ImporterRegistry.INSTANCE.getImporters()) {
            GuiButtonStorage<IImporter> btnImp = new GuiButtonStorage<IImporter>(0, 0, 0, this.btnList.getListWidth(), 20, I18n.func_135052_a((String)imp.getUnlocalisedName(), (Object[])new Object[0]));
            btnImp.setStored(imp);
            this.btnList.addButtonRow(btnImp);
        }
        this.embedded.add(this.btnList);
        int btnX = this.guiLeft + 16 + (this.sizeX - 32) / 4 * 3 - 50;
        this.field_146292_n.add(new GuiButtonThemed(1, btnX, this.guiTop + this.sizeY - 52, 100, 20, I18n.func_135052_a((String)"betterquesting.btn.import", (Object[])new Object[0])));
    }

    @Override
    public void drawBackPanel(int mx, int my, float partialTick) {
        super.drawBackPanel(mx, my, partialTick);
        RenderUtils.DrawLine(this.guiLeft + this.sizeX / 2, this.guiTop + 32, this.guiLeft + this.sizeX / 2, this.guiTop + this.sizeY - 32, 2.0f, this.getTextColor());
    }

    @Override
    public void func_73863_a(int mx, int my, float partialTick) {
        super.func_73863_a(mx, my, partialTick);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 1 && this.selected != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiFileExplorer(this, this, new File("."), this.selected.getFileFilter()));
        }
    }

    public void func_73864_a(int mx, int my, int click) throws IOException {
        super.func_73864_a(mx, my, click);
        GuiButtonThemed btn = this.btnList.getButtonUnderMouse(mx, my);
        if (click == 0 && btn != null && btn.func_146116_c(this.field_146297_k, mx, my)) {
            IImporter imp;
            btn.func_146113_a(this.field_146297_k.func_147118_V());
            this.selected = imp = (IImporter)((GuiButtonStorage)btn).getStored();
            if (this.impGui != null) {
                this.embedded.remove(this.impGui);
            }
            this.impGui = new GuiImporterEmbedded(imp, this.guiLeft + this.sizeX / 2 + 8, this.guiTop + 32, this.sizeX / 2 - 24, this.sizeY - 84);
            this.embedded.add(this.impGui);
        }
    }

    public void setValues(File[] files) {
        if (this.selected != null) {
            ImportedQuests questDB = new ImportedQuests();
            ImportedQuestLines lineDB = new ImportedQuestLines();
            this.selected.loadFiles(questDB, lineDB, files);
            if (questDB.size() > 0 || lineDB.size() > 0) {
                NBTTagCompound jsonBase = new NBTTagCompound();
                jsonBase.func_74782_a("quests", (NBTBase)questDB.writeToNBT(new NBTTagList(), EnumSaveType.CONFIG));
                jsonBase.func_74782_a("lines", (NBTBase)lineDB.writeToNBT(new NBTTagList(), EnumSaveType.CONFIG));
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("data", (NBTBase)jsonBase);
                PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.IMPORT.GetLocation(), tag));
                this.field_146297_k.func_147108_a(this.parent);
            }
        }
    }
}

