/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.gui.QuestLineButtonTree;
import betterquesting.api.client.gui.controls.GuiButtonQuestInstance;
import betterquesting.api.client.gui.misc.IGuiQuestLine;
import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class GuiQuestLinesEmbedded
extends GuiElement
implements IGuiQuestLine {
    private int posX = 0;
    private int posY = 0;
    private int sizeX = 128;
    private int sizeY = 128;
    private int zoom = 100;
    private int scrollX = 0;
    private int scrollY = 0;
    private int maxX = 0;
    private int maxY = 0;
    private boolean noScroll = false;
    private IToolboxTool curTool = null;
    private IQuestLine qLine;
    private final List<GuiButtonQuestInstance> qBtns = new ArrayList<GuiButtonQuestInstance>();
    private QuestLineButtonTree buttonTree = null;
    private ResourceLocation bgImg = null;
    private int bgSize = 1024;
    List<String> curTooltip = null;
    private int lastMX = 0;
    private int lastMY = 0;

    public GuiQuestLinesEmbedded(int posX, int posY, int sizeX, int sizeY) {
        this.posX = posX;
        this.posY = posY;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    @Override
    public void setBackground(ResourceLocation image, int size) {
        this.bgImg = image;
        this.bgSize = Math.max(1, size);
        if (this.bgImg != null) {
            this.maxX = Math.max(this.bgSize, this.maxX);
            this.maxY = Math.max(this.bgSize, this.maxY);
        }
    }

    @Override
    public void setActiveTool(IToolboxTool tool) {
        if (this.curTool != null) {
            this.curTool.disableTool();
        }
        this.curTool = tool;
        if (tool != null) {
            tool.initTool(this);
        }
    }

    @Override
    public IToolboxTool getActiveTool() {
        return this.curTool;
    }

    @Override
    public void copySettings(IGuiQuestLine old) {
        this.zoom = old.getZoom();
        this.scrollX = old.getScrollX();
        this.scrollY = old.getScrollY();
        if (old.getActiveTool() != null) {
            old.getActiveTool().disableTool();
            this.setActiveTool(old.getActiveTool());
        }
    }

    @Override
    public void drawBackground(int mx, int my, float partialTick) {
        this.mouseDrag(mx, my);
        Minecraft mc = Minecraft.func_71410_x();
        double scaleX = (double)this.sizeX / 128.0;
        double scaleY = (double)this.sizeY / 128.0;
        float zs = (float)this.zoom / 100.0f;
        int rmx = this.getRelativeX(mx);
        int rmy = this.getRelativeY(my);
        mc.field_71446_o.func_110577_a(GuiQuestLinesEmbedded.currentTheme().getGuiTexture());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)scaleX, (double)scaleY, (double)1.0);
        GlStateManager.func_179137_b((double)((double)this.posX / scaleX), (double)((double)this.posY / scaleY), (double)0.0);
        this.drawTexturedModalRect(0, 0, 0, 128, 128, 128);
        GlStateManager.func_179121_F();
        IQuest qTooltip = null;
        if (this.qLine != null) {
            GlStateManager.func_179094_E();
            RenderUtils.startScissor(new GuiRectangle(this.posX, this.posY, this.sizeX, this.sizeY));
            GlStateManager.func_179109_b((float)((float)this.posX + (float)this.scrollX * zs), (float)((float)this.posY + (float)this.scrollY * zs), (float)0.0f);
            GlStateManager.func_179152_a((float)zs, (float)zs, (float)1.0f);
            if (this.bgImg != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)((float)this.bgSize / 256.0f), (float)((float)this.bgSize / 256.0f), (float)1.0f);
                mc.field_71446_o.func_110577_a(this.bgImg);
                this.drawTexturedModalRect(0, 0, 0, 0, 256, 256);
                GlStateManager.func_179121_F();
            }
            for (GuiButtonQuestInstance btnQuest : this.qBtns) {
                btnQuest.func_191745_a(mc, rmx, rmy, partialTick);
                if (!btnQuest.field_146125_m || !this.isWithin(rmx, rmy, btnQuest.field_146128_h, btnQuest.field_146129_i, btnQuest.field_146120_f, btnQuest.field_146121_g) || !this.isWithin(mx, my, this.posX, this.posY, this.sizeX, this.sizeY)) continue;
                qTooltip = btnQuest.getQuest();
            }
            RenderUtils.endScissor();
            GlStateManager.func_179121_F();
        }
        if (this.curTool != null) {
            GlStateManager.func_179094_E();
            RenderUtils.startScissor(new GuiRectangle(this.posX, this.posY, this.sizeX, this.sizeY));
            GlStateManager.func_179109_b((float)((float)this.posX + (float)this.scrollX * zs), (float)((float)this.posY + (float)this.scrollY * zs), (float)0.0f);
            GlStateManager.func_179152_a((float)zs, (float)zs, (float)1.0f);
            this.curTool.drawTool(rmx, rmy, partialTick);
            RenderUtils.endScissor();
            GlStateManager.func_179121_F();
        }
        this.curTooltip = qTooltip != null && (this.curTool == null || this.curTool.allowTooltips()) ? qTooltip.getTooltip((EntityPlayer)mc.field_71439_g) : null;
    }

    @Override
    public void drawForeground(int mx, int my, float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.qLine != null) {
            GlStateManager.func_179094_E();
            float scale = this.sizeX > 600 ? 1.5f : 1.0f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.drawString(mc.field_71466_p, I18n.func_135052_a((String)this.qLine.getUnlocalisedName(), (Object[])new Object[0]), MathHelper.func_76123_f((float)((float)(this.posX + 4) / scale)), MathHelper.func_76123_f((float)((float)(this.posY + 4) / scale)), GuiQuestLinesEmbedded.getTextColor(), false);
            this.drawString(mc.field_71466_p, this.zoom + "%", MathHelper.func_76123_f((float)((float)(this.posX + 4) / scale)), MathHelper.func_76123_f((float)((float)(this.posY + this.sizeY - 4 - mc.field_71466_p.field_78288_b) / scale)), GuiQuestLinesEmbedded.getTextColor(), false);
            GlStateManager.func_179121_F();
        }
        if (this.curTooltip != null && this.curTooltip.size() > 0) {
            this.drawTooltip(this.curTooltip, mx, my, Minecraft.func_71410_x().field_71466_p);
            GlStateManager.func_179140_f();
        }
    }

    @Override
    public void onMouseClick(int mx, int my, int click) {
        if (!this.isWithin(mx, my, this.posX, this.posY, this.sizeX, this.sizeY)) {
            this.noScroll = true;
            return;
        }
        if (this.curTool != null) {
            int rmx = this.getRelativeX(mx);
            int rmy = this.getRelativeY(my);
            this.curTool.onMouseClick(rmx, rmy, click);
        }
        this.noScroll = this.curTool != null && !this.curTool.allowScrolling(click);
    }

    @Override
    public void onMouseScroll(int mx, int my, int SDX) {
        if (SDX != 0 && this.isWithin(mx, my, this.posX, this.posY, this.sizeX, this.sizeY)) {
            if (this.curTool != null) {
                this.curTool.onMouseScroll(this.getRelativeX(mx), this.getRelativeY(my), SDX);
                if (!this.curTool.allowZoom()) {
                    return;
                }
            }
            this.setZoom(this.zoom - SDX * 5);
        }
    }

    @Override
    public void onKeyTyped(char c, int key) {
        if (this.curTool != null) {
            this.curTool.onKeyPressed(c, key);
        }
    }

    private void setZoom(int value) {
        this.zoom = MathHelper.func_76125_a((int)value, (int)50, (int)200);
        if (this.curTool == null || !this.curTool.allowZoom()) {
            this.clampScroll();
        }
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public void setQuestLine(QuestLineButtonTree tree, boolean resetView) {
        this.buttonTree = tree;
        if (tree == null) {
            this.qLine = null;
            this.qBtns.clear();
            this.setBackground(null, 256);
        } else {
            this.qLine = tree.getQuestLine();
            this.qBtns.clear();
            this.qBtns.addAll(tree.getButtonTree());
            String bgn = tree.getQuestLine().getProperties().getProperty(NativeProps.BG_IMAGE, "");
            int bgs = tree.getQuestLine().getProperties().getProperty(NativeProps.BG_SIZE, 256);
            if (bgn.length() > 0) {
                this.setBackground(new ResourceLocation(bgn), bgs);
            }
            if (this.bgImg == null) {
                this.maxX = tree.getWidth();
                this.maxY = tree.getHeight();
            } else {
                this.maxX = Math.max(this.bgSize, tree.getWidth());
                this.maxY = Math.max(this.bgSize, tree.getHeight());
            }
            if (resetView) {
                this.zoom = 100;
                this.scrollX = Math.abs(this.sizeX - this.maxX) / 2;
                this.scrollY = 16;
            }
        }
    }

    private void mouseDrag(int mx, int my) {
        int mdx = 0;
        int mdy = 0;
        if (this.lastMX != 0 || this.lastMY != 0) {
            mdx = mx - this.lastMX;
            mdy = my - this.lastMY;
        }
        this.lastMX = mx;
        this.lastMY = my;
        if (Mouse.isButtonDown((int)0) && !this.noScroll || Mouse.isButtonDown((int)2)) {
            float zs = (float)this.zoom / 100.0f;
            this.scrollX = (int)((float)this.scrollX + (float)mdx / zs);
            this.scrollY = (int)((float)this.scrollY + (float)mdy / zs);
            if (this.curTool == null || this.curTool.clampScrolling()) {
                this.clampScroll();
            }
        }
    }

    public void clampScroll() {
        float zs = (float)this.zoom / 100.0f;
        int sx2 = (int)((float)this.sizeX / zs);
        int sy2 = (int)((float)this.sizeY / zs);
        int zmx = Math.abs(sx2 / 2 - (this.maxX + 32) / 2);
        int zmy = Math.abs(sy2 / 2 - (this.maxY + 32) / 2);
        int zox = sx2 / 2 - (this.maxX + 32) / 2 + 16;
        int zoy = sy2 / 2 - (this.maxY + 32) / 2 + 16;
        this.scrollX = MathHelper.func_76125_a((int)this.scrollX, (int)(-zmx + zox), (int)(zmx + zox));
        this.scrollY = MathHelper.func_76125_a((int)this.scrollY, (int)(-zmy + zoy), (int)(zmy + zoy));
    }

    @Override
    public int getRelativeX(int x) {
        float zs = (float)this.zoom / 100.0f;
        return (int)((float)(x - this.posX) / zs) - this.scrollX;
    }

    @Override
    public int getRelativeY(int y) {
        float zs = (float)this.zoom / 100.0f;
        return (int)((float)(y - this.posY) / zs) - this.scrollY;
    }

    @Override
    public int getScreenX(int x) {
        float zs = (float)this.zoom / 100.0f;
        return (int)((float)(x + this.scrollX) * zs) + this.posX;
    }

    @Override
    public int getScreenY(int y) {
        float zs = (float)this.zoom / 100.0f;
        return (int)((float)(y + this.scrollY) * zs) + this.posY;
    }

    @Override
    public int getPosX() {
        return this.posX;
    }

    @Override
    public int getPosY() {
        return this.posY;
    }

    @Override
    public int getWidth() {
        return this.sizeX;
    }

    @Override
    public int getHeight() {
        return this.sizeY;
    }

    @Override
    public int getScrollX() {
        return this.scrollX;
    }

    @Override
    public int getScrollY() {
        return this.scrollY;
    }

    @Override
    public QuestLineButtonTree getQuestLine() {
        return this.buttonTree;
    }
}

