/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabase;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class BigDatabase<T>
implements IDatabase<T> {
    private final SortedSet<DBEntry<SortedSet<DBEntry<T>>>> dbBlocks = Collections.synchronizedSortedSet(new TreeSet((o1, o2) -> o1.getValue() == o2.getValue() ? 0 : Integer.compare(o1.getID(), o2.getID())));
    private final int blockSize;

    public BigDatabase() {
        this(100);
    }

    public BigDatabase(int blockSize) {
        this.blockSize = blockSize <= 0 ? 1 : blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextID() {
        SortedSet<DBEntry<SortedSet<DBEntry<T>>>> sortedSet = this.dbBlocks;
        synchronized (sortedSet) {
            int blockID = 0;
            for (DBEntry dBEntry : this.dbBlocks) {
                if (blockID != dBEntry.getID()) {
                    return blockID * this.blockSize;
                }
                if (((SortedSet)dBEntry.getValue()).size() >= this.blockSize) {
                    ++blockID;
                    continue;
                }
                DBEntry[] entryList = ((SortedSet)dBEntry.getValue()).toArray(new DBEntry[0]);
                int startID = blockID * this.blockSize;
                for (int i = 0; i < entryList.length; ++i) {
                    if (entryList[i].getID() == startID + i) continue;
                    return startID + i;
                }
                return dBEntry.getID() * this.blockSize + entryList.length;
            }
            return blockID * this.blockSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBEntry<T> add(int id, T value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (id < 0) {
            throw new IllegalArgumentException("ID cannot be negative");
        }
        int blockID = id / this.blockSize;
        SortedSet<DBEntry<SortedSet<DBEntry<T>>>> sortedSet = this.dbBlocks;
        synchronized (sortedSet) {
            DBEntry blockEntry;
            Iterator iterator = this.dbBlocks.iterator();
            while (iterator.hasNext() && (blockEntry = (DBEntry)iterator.next()).getID() <= blockID) {
                if (blockEntry.getID() != blockID) continue;
                DBEntry<T> entry = new DBEntry<T>(id, value);
                if (((SortedSet)blockEntry.getValue()).add(entry)) {
                    return entry;
                }
                throw new IllegalArgumentException("ID or value is already contained within database");
            }
            SortedSet<DBEntry<T>> block = Collections.synchronizedSortedSet(new TreeSet());
            DBEntry<T> entry = new DBEntry<T>(id, value);
            block.add(entry);
            this.dbBlocks.add(new DBEntry(blockID, block));
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeID(int id) {
        SortedSet<DBEntry<SortedSet<DBEntry<T>>>> sortedSet = this.dbBlocks;
        synchronized (sortedSet) {
            for (DBEntry dBEntry : this.dbBlocks) {
                if (id / this.blockSize < dBEntry.getID()) {
                    return false;
                }
                if (!this.removeIDFromBlock((SortedSet)dBEntry.getValue(), id)) continue;
                return true;
            }
            return false;
        }
    }

    private boolean removeIDFromBlock(SortedSet<DBEntry<T>> block, int id) {
        if (id < 0) {
            return false;
        }
        DBEntry removed = null;
        Iterator iter = block.iterator();
        while (iter.hasNext()) {
            DBEntry entry = (DBEntry)iter.next();
            if (entry.getID() == id) {
                iter.remove();
                removed = entry;
                break;
            }
            if (entry.getID() <= id) continue;
            break;
        }
        return removed != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeValue(T value) {
        SortedSet<DBEntry<SortedSet<DBEntry<T>>>> sortedSet = this.dbBlocks;
        synchronized (sortedSet) {
            for (DBEntry dBEntry : this.dbBlocks) {
                if (!this.removeValueFromBlock((SortedSet)dBEntry.getValue(), value)) continue;
                return true;
            }
            return false;
        }
    }

    private boolean removeValueFromBlock(SortedSet<DBEntry<T>> block, T value) {
        if (value == null) {
            return false;
        }
        DBEntry removed = null;
        Iterator iter = block.iterator();
        while (iter.hasNext()) {
            DBEntry entry = (DBEntry)iter.next();
            if (entry.getValue() != value) continue;
            iter.remove();
            removed = entry;
            break;
        }
        return removed != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getID(T value) {
        SortedSet<DBEntry<SortedSet<DBEntry<T>>>> sortedSet = this.dbBlocks;
        synchronized (sortedSet) {
            for (DBEntry dBEntry : this.dbBlocks) {
                int id = this.getIDFromBlock((SortedSet)dBEntry.getValue(), value);
                if (id < 0) continue;
                return id;
            }
            return -1;
        }
    }

    private int getIDFromBlock(SortedSet<DBEntry<T>> block, T value) {
        if (value == null) {
            return -1;
        }
        for (DBEntry dBEntry : block) {
            if (dBEntry.getValue() != value) continue;
            return dBEntry.getID();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getValue(int id) {
        SortedSet<DBEntry<SortedSet<DBEntry<T>>>> sortedSet = this.dbBlocks;
        synchronized (sortedSet) {
            DBEntry blockEntry;
            Iterator iterator = this.dbBlocks.iterator();
            while (iterator.hasNext() && id / this.blockSize >= (blockEntry = (DBEntry)iterator.next()).getID()) {
                if (blockEntry.getID() != id / this.blockSize) continue;
                return this.getValueFromBlock((SortedSet)blockEntry.getValue(), id);
            }
            return null;
        }
    }

    private T getValueFromBlock(SortedSet<DBEntry<T>> block, int id) {
        if (id < 0 || block.size() <= 0 || id > block.last().getID()) {
            return null;
        }
        for (DBEntry dBEntry : block) {
            if (dBEntry.getID() > id) {
                return null;
            }
            if (dBEntry.getID() != id) continue;
            return dBEntry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int s = 0;
        SortedSet<DBEntry<SortedSet<DBEntry<T>>>> sortedSet = this.dbBlocks;
        synchronized (sortedSet) {
            for (DBEntry dBEntry : this.dbBlocks) {
                s += ((SortedSet)dBEntry.getValue()).size();
            }
        }
        return s;
    }

    @Override
    public void reset() {
        this.dbBlocks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBEntry<T>[] getEntries() {
        SortedSet<DBEntry<SortedSet<DBEntry<T>>>> sortedSet = this.dbBlocks;
        synchronized (sortedSet) {
            DBEntry[] array = new DBEntry[this.size()];
            int i = 0;
            for (DBEntry dBEntry : this.dbBlocks) {
                DBEntry[] dBEntryArray = ((SortedSet)dBEntry.getValue()).toArray(new DBEntry[0]);
                int n = dBEntryArray.length;
                for (int j = 0; j < n; ++j) {
                    DBEntry entry;
                    array[i] = entry = dBEntryArray[j];
                    ++i;
                }
            }
            return array;
        }
    }
}

