/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.lists;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.misc.ComparatorGuiDepth;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiCanvas;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.lists.CanvasCullingManager;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class CanvasScrolling
implements IGuiCanvas {
    private final List<IGuiPanel> guiPanels = new CopyOnWriteArrayList<IGuiPanel>();
    private final IGuiRect transform;
    private boolean enabled = true;
    protected final GuiRectangle scrollBounds = new GuiRectangle(0, 0, 0, 0);
    private final GuiRectangle scrollWindow = new GuiRectangle(0, 0, 0, 0);
    protected boolean extendedScroll = false;
    protected boolean zoomMode = false;
    protected int margin = 0;
    protected IValueIO<Float> scrollX;
    protected IValueIO<Float> scrollY;
    protected IValueIO<Float> zoomScale;
    private boolean isDragging = false;
    private boolean hasDragged = false;
    protected int scrollSpeed = 12;
    private float dragSX = 0.0f;
    private float dragSY = 0.0f;
    private int dragMX = 0;
    private int dragMY = 0;
    private int lsx = 0;
    private int lsy = 0;
    private boolean useBlocking = true;
    private final CanvasCullingManager cullingManager = new CanvasCullingManager();

    public CanvasScrolling(IGuiRect rect) {
        this.transform = rect;
        this.scrollX = new IValueIO<Float>(){
            private float v = 0.0f;

            @Override
            public Float readValue() {
                return Float.valueOf(this.v);
            }

            @Override
            public void writeValue(Float value) {
                this.v = MathHelper.func_76131_a((float)value.floatValue(), (float)0.0f, (float)1.0f);
            }
        };
        this.scrollY = new IValueIO<Float>(){
            private float v = 0.0f;

            @Override
            public Float readValue() {
                return Float.valueOf(this.v);
            }

            @Override
            public void writeValue(Float value) {
                this.v = MathHelper.func_76131_a((float)value.floatValue(), (float)0.0f, (float)1.0f);
            }
        };
        this.zoomScale = new IValueIO<Float>(){
            private float v = 1.0f;

            @Override
            public Float readValue() {
                return Float.valueOf(this.v);
            }

            @Override
            public void writeValue(Float value) {
                this.v = MathHelper.func_76131_a((float)value.floatValue(), (float)0.25f, (float)2.0f);
            }
        };
    }

    public CanvasScrolling setScrollDriverX(IValueIO<Float> driver) {
        this.scrollX = driver;
        return this;
    }

    public CanvasScrolling setScrollDriverY(IValueIO<Float> driver) {
        this.scrollY = driver;
        return this;
    }

    public CanvasScrolling setZoomDriver(IValueIO<Float> driver) {
        this.zoomScale = driver;
        return this;
    }

    public CanvasScrolling setScrollSpeed(int dx) {
        this.scrollSpeed = dx;
        return this;
    }

    public CanvasScrolling setupAdvanceScroll(boolean scrollToZoom, boolean extendedScroll, int scrollMargin) {
        this.zoomMode = scrollToZoom;
        this.extendedScroll = extendedScroll;
        this.margin = scrollMargin;
        return this;
    }

    public CanvasScrolling enableBlocking(boolean state) {
        this.useBlocking = state;
        return this;
    }

    public IGuiRect getScrollBounds() {
        return this.scrollBounds;
    }

    public int getScrollX() {
        return Math.round((float)this.scrollBounds.getX() + (float)this.scrollBounds.getWidth() * this.scrollX.readValue().floatValue());
    }

    public int getScrollY() {
        return Math.round((float)this.scrollBounds.getY() + (float)this.scrollBounds.getHeight() * this.scrollY.readValue().floatValue());
    }

    public float getZoom() {
        return this.zoomScale.readValue().floatValue();
    }

    public void setScrollX(int sx) {
        if (this.scrollBounds.getWidth() <= 0) {
            return;
        }
        this.scrollX.writeValue(Float.valueOf((float)(sx - this.scrollBounds.getX()) / (float)this.scrollBounds.getWidth()));
        this.lsx = this.getScrollX();
    }

    public void setScrollY(int sy) {
        if (this.scrollBounds.getHeight() <= 0) {
            return;
        }
        this.scrollY.writeValue(Float.valueOf((float)(sy - this.scrollBounds.getY()) / (float)this.scrollBounds.getHeight()));
        this.lsx = this.getScrollY();
    }

    public void setZoom(float z) {
        this.zoomScale.writeValue(Float.valueOf(z));
        this.refreshScrollBounds();
    }

    @Override
    public void initPanel() {
        this.guiPanels.clear();
        this.cullingManager.reset();
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        float zs = this.zoomScale.readValue().floatValue();
        if (this.isDragging) {
            int dx = (int)((float)(this.dragMX - mx) / zs);
            int dy = (int)((float)(this.dragMY - my) / zs);
            if (this.scrollBounds.getWidth() > 0) {
                float dsx = (float)dx / (float)this.scrollBounds.getWidth() + this.dragSX;
                this.scrollX.writeValue(Float.valueOf(dsx));
                if (!this.hasDragged && Math.abs(this.dragSX - this.scrollX.readValue().floatValue()) > 0.05f) {
                    this.hasDragged = true;
                }
            }
            if (this.scrollBounds.getHeight() > 0) {
                float dsy = (float)dy / (float)this.scrollBounds.getHeight() + this.dragSY;
                this.scrollY.writeValue(Float.valueOf(dsy));
                if (!this.hasDragged && Math.abs(this.dragSY - this.scrollY.readValue().floatValue()) > 0.05f) {
                    this.hasDragged = true;
                }
            }
        } else if (this.hasDragged) {
            this.hasDragged = false;
        }
        if (this.lsx != this.getScrollX() || this.lsy != this.getScrollY()) {
            this.updatePanelScroll();
        }
        GlStateManager.func_179094_E();
        RenderUtils.startScissor(this.transform);
        int tx = this.transform.getX();
        int ty = this.transform.getY();
        GlStateManager.func_179109_b((float)((float)tx - (float)this.lsx * zs), (float)((float)ty - (float)this.lsy * zs), (float)0.0f);
        GlStateManager.func_179152_a((float)zs, (float)zs, (float)zs);
        int smx = (int)((float)(mx - tx) / zs) + this.lsx;
        int smy = (int)((float)(my - ty) / zs) + this.lsy;
        for (IGuiPanel panel : this.getVisiblePanels()) {
            if (!panel.isEnabled()) continue;
            panel.drawPanel(smx, smy, partialTick);
        }
        RenderUtils.endScissor();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (!this.transform.contains(mx, my)) {
            return false;
        }
        float zs = this.zoomScale.readValue().floatValue();
        int tx = this.transform.getX();
        int ty = this.transform.getY();
        int smx = (int)((float)(mx - tx) / zs) + this.lsx;
        int smy = (int)((float)(my - ty) / zs) + this.lsy;
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseClick(smx, smy, click)) continue;
            used = true;
            break;
        }
        if (!(used || click != 0 && click != 2)) {
            this.dragSX = this.scrollX.readValue().floatValue();
            this.dragSY = this.scrollY.readValue().floatValue();
            this.dragMX = mx;
            this.dragMY = my;
            this.isDragging = true;
        }
        return used;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        boolean used = false;
        if (!this.hasDragged) {
            if (!this.transform.contains(mx, my)) {
                return false;
            }
            float zs = this.zoomScale.readValue().floatValue();
            int tx = this.transform.getX();
            int ty = this.transform.getY();
            int smx = (int)((float)(mx - tx) / zs) + this.lsx;
            int smy = (int)((float)(my - ty) / zs) + this.lsy;
            ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
            while (pnIter.hasPrevious()) {
                if (!pnIter.previous().onMouseRelease(smx, smy, click)) continue;
                used = true;
                break;
            }
        }
        if (this.isDragging) {
            if (!Mouse.isButtonDown((int)0) && !Mouse.isButtonDown((int)2)) {
                this.isDragging = false;
            }
            return true;
        }
        return used;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        if (scroll == 0 || !this.transform.contains(mx, my)) {
            return false;
        }
        float zs = this.zoomScale.readValue().floatValue();
        int tx = this.transform.getX();
        int ty = this.transform.getY();
        int smx = (int)((float)(mx - tx) / zs) + this.lsx;
        int smy = (int)((float)(my - ty) / zs) + this.lsy;
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseScroll(smx, smy, scroll)) continue;
            used = true;
            break;
        }
        if (!used) {
            if (this.zoomMode) {
                float dy = (float)(-scroll) * 0.05f;
                float cs = this.zoomScale.readValue().floatValue();
                this.zoomScale.writeValue(Float.valueOf(cs + dy));
                this.refreshScrollBounds();
            } else if (this.scrollBounds.getHeight() > 0) {
                float dy = (float)(scroll * this.scrollSpeed) / (float)this.scrollBounds.getHeight();
                float cs = this.scrollY.readValue().floatValue();
                if (!(dy < 0.0f && cs <= 0.0f || dy > 0.0f && cs >= 1.0f)) {
                    this.scrollY.writeValue(Float.valueOf(cs + dy));
                    this.updatePanelScroll();
                }
            }
        }
        return used;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onKeyTyped(c, keycode)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        if (!this.transform.contains(mx, my)) {
            return null;
        }
        float zs = this.zoomScale.readValue().floatValue();
        int tx = this.transform.getX();
        int ty = this.transform.getY();
        int smx = (int)((float)(mx - tx) / zs) + this.lsx;
        int smy = (int)((float)(my - ty) / zs) + this.lsy;
        List<IGuiPanel> tmpList = this.getVisiblePanels();
        ListIterator<IGuiPanel> pnIter = tmpList.listIterator(tmpList.size());
        while (pnIter.hasPrevious()) {
            List<String> tt;
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || (tt = entry.getTooltip(smx, smy)) == null || tt.size() <= 0) continue;
            return tt;
        }
        return null;
    }

    @Override
    public void addPanel(IGuiPanel panel) {
        this.addCulledPanel(panel, true);
    }

    public void addCulledPanel(IGuiPanel panel, boolean useCulling) {
        if (panel == null || this.guiPanels.contains(panel)) {
            return;
        }
        this.guiPanels.add(panel);
        this.guiPanels.sort(ComparatorGuiDepth.INSTANCE);
        this.cullingManager.addPanel(panel, useCulling);
        panel.initPanel();
        this.refreshScrollBounds();
    }

    @Override
    public boolean removePanel(IGuiPanel panel) {
        boolean b = this.guiPanels.remove(panel);
        if (b) {
            this.cullingManager.removePanel(panel);
            this.refreshScrollBounds();
        }
        return b;
    }

    public void refreshScrollBounds() {
        boolean first = true;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        float zs = this.zoomScale.readValue().floatValue();
        for (IGuiPanel panel : this.guiPanels) {
            if (first) {
                left = panel.getTransform().getX();
                top = panel.getTransform().getY();
                right = panel.getTransform().getX() + panel.getTransform().getWidth();
                bottom = panel.getTransform().getY() + panel.getTransform().getHeight();
                first = false;
                continue;
            }
            left = Math.min(left, panel.getTransform().getX());
            top = Math.min(top, panel.getTransform().getY());
            right = Math.max(right, panel.getTransform().getX() + panel.getTransform().getWidth());
            bottom = Math.max(bottom, panel.getTransform().getY() + panel.getTransform().getHeight());
        }
        left -= this.margin;
        right += this.margin;
        top -= this.margin;
        bottom += this.margin;
        right -= (int)Math.ceil((float)this.getTransform().getWidth() / zs);
        bottom -= (int)Math.ceil((float)this.getTransform().getHeight() / zs);
        if (this.extendedScroll) {
            this.scrollBounds.x = Math.min(left, right);
            this.scrollBounds.y = Math.min(top, bottom);
            this.scrollBounds.w = Math.max(left, right) - this.scrollBounds.x;
            this.scrollBounds.h = Math.max(top, bottom) - this.scrollBounds.y;
        } else {
            this.scrollBounds.x = left;
            this.scrollBounds.y = top;
            this.scrollBounds.w = Math.max(0, right - left);
            this.scrollBounds.h = Math.max(0, bottom - top);
        }
        this.updatePanelScroll();
    }

    public void updatePanelScroll() {
        this.lsx = this.getScrollX();
        this.lsy = this.getScrollY();
        float zs = this.zoomScale.readValue().floatValue();
        this.scrollWindow.x = this.lsx;
        this.scrollWindow.y = this.lsy;
        this.scrollWindow.w = (int)Math.ceil((float)this.transform.getWidth() / zs);
        this.scrollWindow.h = (int)Math.ceil((float)this.transform.getHeight() / zs);
        this.cullingManager.updateVisiblePanels(this.scrollWindow);
    }

    @Override
    public void resetCanvas() {
        this.guiPanels.clear();
        this.cullingManager.reset();
        this.refreshScrollBounds();
    }

    private List<IGuiPanel> getVisiblePanels() {
        if (this.useBlocking) {
            return this.cullingManager.getVisiblePanels();
        }
        return this.guiPanels;
    }
}

