/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.lists;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.utils.QuestTranslation;
import com.google.common.base.Stopwatch;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class CanvasItemDatabase
extends CanvasScrolling {
    private final int btnId;
    private String searchTerm = "";
    private Iterator<Item> searching = null;
    private final Stopwatch searchTime = Stopwatch.createStarted();
    private int resultWidth = 256;
    private int searchIdx = 0;
    private final ArrayDeque<ItemStack> pendingResults = new ArrayDeque();

    public CanvasItemDatabase(IGuiRect rect, int buttonId) {
        super(rect);
        this.btnId = buttonId;
    }

    public void setSearchFilter(String text) {
        this.resetCanvas();
        this.searchTerm = text.toLowerCase();
        this.searchIdx = 0;
        this.searching = Item.field_150901_e.iterator();
        this.resultWidth = this.getTransform().getWidth();
        this.pendingResults.clear();
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.searchIdx = 0;
        this.searching = Item.field_150901_e.iterator();
        this.resultWidth = this.getTransform().getWidth();
        this.pendingResults.clear();
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        this.updateSearch();
        this.updateResults();
        super.drawPanel(mx, my, partialTick);
    }

    private void updateSearch() {
        if (this.searching == null) {
            return;
        }
        if (!this.searching.hasNext()) {
            this.searching = null;
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        this.searchTime.reset().start();
        while (this.searching.hasNext() && this.searchTime.elapsed(TimeUnit.MILLISECONDS) < 10L) {
            Item item = this.searching.next();
            if (item == null || item == Items.field_190931_a || item.getRegistryName() == null) continue;
            try {
                NonNullList subList = NonNullList.func_191196_a();
                item.func_150895_a(CreativeTabs.field_78027_g, subList);
                if (item.func_190903_i().func_190926_b()) {
                    throw new IllegalArgumentException("Invalid default stack instance for item \"" + item.getRegistryName() + "\"!");
                }
                if (subList.isEmpty()) {
                    subList.add((Object)item.func_190903_i());
                }
                if (item.func_77658_a().toLowerCase().contains(this.searchTerm) || QuestTranslation.translate(item.func_77658_a(), new Object[0]).toLowerCase().contains(this.searchTerm) || item.getRegistryName().toString().toLowerCase().contains(this.searchTerm)) {
                    this.pendingResults.addAll((Collection<ItemStack>)subList);
                    continue;
                }
                block3: for (ItemStack subItem : subList) {
                    if (subItem.func_190926_b()) {
                        throw new IllegalArgumentException("Invalid item stack \"" + subItem + "\" registed to creative search tab!");
                    }
                    if (subItem.func_77977_a().toLowerCase().contains(this.searchTerm) || subItem.func_82833_r().toLowerCase().contains(this.searchTerm)) {
                        this.pendingResults.add(subItem);
                        continue;
                    }
                    boolean match = false;
                    for (String s : subItem.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL))) {
                        if (!s.toLowerCase().contains(this.searchTerm)) continue;
                        this.pendingResults.add(subItem);
                        match = true;
                        break;
                    }
                    int[] oids = OreDictionary.getOreIDs((ItemStack)subItem);
                    for (int i = 0; i < oids.length && !match; ++i) {
                        if (!OreDictionary.getOreName((int)oids[i]).toLowerCase().contains(this.searchTerm)) continue;
                        this.pendingResults.add(subItem);
                        continue block3;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Item \"" + item.getRegistryName() + "\" (" + item.getClass().getName() + ") threw a fatal error during search! Please report this to the item's developer(s).", e);
            }
        }
        this.searchTime.stop();
    }

    private void updateResults() {
        if (this.pendingResults.isEmpty()) {
            return;
        }
        int rowMax = this.resultWidth / 18;
        this.searchTime.reset().start();
        while (!this.pendingResults.isEmpty() && this.searchTime.elapsed(TimeUnit.MILLISECONDS) < 100L) {
            ItemStack stack = this.pendingResults.poll();
            if (stack == null || stack.func_190926_b()) continue;
            int x = this.searchIdx % rowMax * 18;
            int y = this.searchIdx / rowMax * 18;
            this.addPanel(new PanelItemSlot((IGuiRect)new GuiRectangle(x, y, 18, 18, 0), this.btnId, new BigItemStack(stack)));
            ++this.searchIdx;
        }
        this.searchTime.stop();
    }
}

