/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.lists;

import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.content.PanelFluidSlot;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import com.google.common.base.Stopwatch;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CanvasFluidDatabase
extends CanvasScrolling {
    private final int btnId;
    private String searchTerm = "";
    private Iterator<Fluid> searching = null;
    private final Stopwatch searchTime = Stopwatch.createStarted();
    private int resultWidth = 256;
    private int searchIdx = 0;
    private final ArrayDeque<FluidStack> pendingResults = new ArrayDeque();

    public CanvasFluidDatabase(IGuiRect rect, int buttonId) {
        super(rect);
        this.btnId = buttonId;
    }

    public void setSearchFilter(String text) {
        this.resetCanvas();
        this.searchTerm = text.toLowerCase();
        this.searchIdx = 0;
        this.searching = FluidRegistry.getRegisteredFluids().values().iterator();
        this.resultWidth = this.getTransform().getWidth();
        this.pendingResults.clear();
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.searchIdx = 0;
        this.searching = FluidRegistry.getRegisteredFluids().values().iterator();
        this.resultWidth = this.getTransform().getWidth();
        this.pendingResults.clear();
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        this.updateSearch();
        this.updateResults();
        super.drawPanel(mx, my, partialTick);
    }

    private void updateSearch() {
        if (this.searching == null) {
            return;
        }
        if (!this.searching.hasNext()) {
            this.searching = null;
            return;
        }
        this.searchTime.reset().start();
        while (this.searching.hasNext() && this.searchTime.elapsed(TimeUnit.MILLISECONDS) < 10L) {
            Fluid fluid = this.searching.next();
            if (fluid == null || fluid.getName() == null) continue;
            try {
                FluidStack stack = new FluidStack(fluid, 1000);
                if (!fluid.getUnlocalizedName().toLowerCase().contains(this.searchTerm) && !fluid.getLocalizedName(stack).toLowerCase().contains(this.searchTerm) && !fluid.getName().toLowerCase().contains(this.searchTerm)) continue;
                this.pendingResults.add(stack);
            }
            catch (Exception e) {
                throw new RuntimeException("Fluid \"" + fluid.getName() + "\" (" + fluid.getClass().getName() + ") threw a fatal error during search!", e);
            }
        }
        this.searchTime.stop();
    }

    private void updateResults() {
        if (this.pendingResults.isEmpty()) {
            return;
        }
        int rowMax = this.resultWidth / 18;
        this.searchTime.reset().start();
        while (!this.pendingResults.isEmpty() && this.searchTime.elapsed(TimeUnit.MILLISECONDS) < 100L) {
            FluidStack stack = this.pendingResults.poll();
            if (stack == null) continue;
            int x = this.searchIdx % rowMax * 18;
            int y = this.searchIdx / rowMax * 18;
            this.addPanel(new PanelFluidSlot((IGuiRect)new GuiRectangle(x, y, 18, 18, 0), this.btnId, stack));
            ++this.searchIdx;
        }
        this.searchTime.stop();
    }
}

