/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.lists;

import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CanvasEntityDatabase
extends CanvasScrolling {
    private final int btnId;
    private String searchTerm = "";
    private Iterator<EntityEntry> searching;
    private final Stopwatch searchTime = Stopwatch.createStarted();
    private int resultWidth = 256;
    private int searchIdx = 0;
    private final List<EntityEntry> pendingResults = new ArrayList<EntityEntry>();

    public CanvasEntityDatabase(IGuiRect rect, int buttonId) {
        super(rect);
        this.btnId = buttonId;
    }

    public void setSearchFilter(String text) {
        this.resetCanvas();
        this.searchTerm = text.toLowerCase();
        this.searchIdx = 0;
        this.searching = ForgeRegistries.ENTITIES.iterator();
        this.resultWidth = this.getTransform().getWidth();
        this.pendingResults.clear();
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.searchIdx = 0;
        this.searching = ForgeRegistries.ENTITIES.iterator();
        this.resultWidth = this.getTransform().getWidth();
        this.pendingResults.clear();
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        this.updateSearch();
        if (this.searching == null) {
            this.updateResults();
        }
        super.drawPanel(mx, my, partialTick);
    }

    private void updateSearch() {
        if (this.searching == null) {
            return;
        }
        if (!this.searching.hasNext()) {
            this.searching = null;
            this.pendingResults.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
            return;
        }
        this.searchTime.reset().start();
        while (this.searching.hasNext() && this.searchTime.elapsed(TimeUnit.MILLISECONDS) < 10L) {
            EntityEntry ee = this.searching.next();
            if (ee == null || ee.getRegistryName() == null || !ee.getRegistryName().toString().toLowerCase().contains(this.searchTerm) && !ee.getName().toLowerCase().contains(this.searchTerm) && !ee.getEntityClass().toString().toLowerCase().contains(this.searchTerm)) continue;
            this.pendingResults.add(ee);
        }
        this.searchTime.stop();
    }

    private void updateResults() {
        if (this.pendingResults.isEmpty()) {
            return;
        }
        this.searchTime.reset().start();
        while (!this.pendingResults.isEmpty() && this.searchTime.elapsed(TimeUnit.MILLISECONDS) < 100L) {
            EntityEntry ee = this.pendingResults.remove(0);
            if (ee == null) continue;
            this.addPanel(new PanelButtonStorage<EntityEntry>(new GuiRectangle(0, this.searchIdx * 16, this.resultWidth, 16, 0), this.btnId, ee.getName(), ee));
            ++this.searchIdx;
        }
        this.searchTime.stop();
    }
}

