/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.content;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.textures.ColorTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.resources.textures.LayeredTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;

public class PanelItemSlot
extends PanelButtonStorage<BigItemStack> {
    private final boolean showCount;

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value) {
        this(rect, id, value, false);
    }

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value, boolean showCount) {
        super(rect, id, "", value);
        this.showCount = showCount;
        this.setTextures(PresetTexture.ITEM_FRAME.getTexture(), PresetTexture.ITEM_FRAME.getTexture(), new LayeredTexture(PresetTexture.ITEM_FRAME.getTexture(), new ColorTexture(PresetColor.ITEM_HIGHLIGHT.getColor(), new GuiPadding(1, 1, 1, 1))));
        this.setStoredValue(value);
    }

    public PanelItemSlot setStoredValue(BigItemStack value) {
        super.setStoredValue(value);
        if (value != null) {
            Minecraft mc = Minecraft.func_71410_x();
            this.setIcon(new ItemTexture(value, this.showCount, true), 1);
            this.setTooltip(value.getBaseStack().func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
        } else {
            this.setIcon(null);
            this.setTooltip(null);
        }
        return this;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        if (this.getStoredValue() != null && this.getTransform().contains(mx, my)) {
            Minecraft mc = Minecraft.func_71410_x();
            return ((BigItemStack)this.getStoredValue()).getBaseStack().func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        }
        return null;
    }
}

