/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.bars;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.bars.IBarFill;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;

public class PanelVBarFill
implements IBarFill {
    private final IGuiRect transform;
    private boolean enabled = true;
    private IGuiTexture texBack;
    private IGuiTexture texFill;
    private IValueIO<Float> fillDriver;
    private boolean flipBar = false;
    private int clrNorm = Color.WHITE.getRGB();
    private int clrLow = Color.WHITE.getRGB();
    private float clrThreshold = 0.25f;
    private boolean lerpClr = false;

    public PanelVBarFill(IGuiRect rect) {
        this.texBack = PresetTexture.METER_V_0.getTexture();
        this.texFill = PresetTexture.METER_V_1.getTexture();
        this.transform = rect;
        this.fillDriver = new IValueIO<Float>(){

            @Override
            public Float readValue() {
                return Float.valueOf(1.0f);
            }

            @Override
            public void writeValue(Float value) {
            }
        };
    }

    @Override
    public PanelVBarFill setFillDriver(IValueIO<Float> driver) {
        this.fillDriver = driver;
        return this;
    }

    @Override
    public PanelVBarFill setFlipped(boolean flipped) {
        this.flipBar = flipped;
        return this;
    }

    @Override
    public PanelVBarFill setFillColor(int low, int high, float threshold, boolean lerp) {
        this.clrNorm = high;
        this.clrLow = low;
        this.clrThreshold = threshold;
        this.lerpClr = lerp;
        return this;
    }

    @Override
    public PanelVBarFill setBarTexture(IGuiTexture back, IGuiTexture front) {
        this.texBack = back;
        this.texFill = front;
        return this;
    }

    @Override
    public void initPanel() {
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        IGuiRect bounds = this.getTransform();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.texBack != null) {
            this.texBack.drawTexture(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 0.0f, partialTick);
        }
        float f = MathHelper.func_76131_a((float)this.fillDriver.readValue().floatValue(), (float)0.0f, (float)1.0f);
        if (this.flipBar) {
            RenderUtils.startScissor(new GuiRectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), (int)((float)bounds.getHeight() * f), 0));
        } else {
            RenderUtils.startScissor(new GuiRectangle(bounds.getX(), bounds.getY() + (int)((float)bounds.getHeight() - (float)bounds.getHeight() * f), bounds.getWidth(), (int)((float)bounds.getHeight() * f), 0));
        }
        if (this.clrThreshold > 0.0f && f < this.clrThreshold) {
            int tmpC = this.clrLow;
            if (this.lerpClr) {
                tmpC = RenderUtils.lerpRGB(this.clrLow, this.clrNorm, f / this.clrThreshold);
            }
            int a1 = tmpC >> 24 & 0xFF;
            int r1 = tmpC >> 16 & 0xFF;
            int g1 = tmpC >> 8 & 0xFF;
            int b1 = tmpC & 0xFF;
            GlStateManager.func_179131_c((float)((float)r1 / 255.0f), (float)((float)g1 / 255.0f), (float)((float)b1 / 255.0f), (float)((float)a1 / 255.0f));
        } else {
            int a1 = this.clrNorm >> 24 & 0xFF;
            int r1 = this.clrNorm >> 16 & 0xFF;
            int g1 = this.clrNorm >> 8 & 0xFF;
            int b1 = this.clrNorm & 0xFF;
            GlStateManager.func_179131_c((float)((float)r1 / 255.0f), (float)((float)g1 / 255.0f), (float)((float)b1 / 255.0f), (float)((float)a1 / 255.0f));
        }
        if (this.texFill != null) {
            this.texFill.drawTexture(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 0.0f, partialTick);
        }
        RenderUtils.endScissor();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        return false;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return null;
    }
}

