/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.events;

import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventFilter;
import betterquesting.api2.client.gui.events.PanelEvent;
import java.util.ArrayList;

public class PEventEntry<T extends PanelEvent> {
    private final ArrayList<IPEventListener> listeners = new ArrayList();
    private final PEventFilter<T> filter;

    public PEventEntry(Class<T> type) {
        this.filter = new PEventFilter<T>(type);
    }

    public void registerListener(IPEventListener l) {
        if (l == null || this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void unregisterListener(IPEventListener l) {
        this.listeners.remove(l);
    }

    public PEventFilter<T> getTypeFilter() {
        return this.filter;
    }

    public void fire(PanelEvent event) {
        if (!this.filter.isCompatible(event)) {
            return;
        }
        for (IPEventListener l : this.listeners) {
            l.onPanelEvent(event);
        }
    }
}

