/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.utils;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class QuestCache {
    public static final QuestCache INSTANCE = new QuestCache();
    private final HashMap<UUID, HashMap<Integer, List<Integer>>> rawCache = new HashMap();

    private QuestCache() {
    }

    public void updateCache(EntityPlayer player) {
        DBEntry<T>[] idList;
        if (player == null) {
            return;
        }
        UUID uuid = QuestingAPI.getQuestingUUID(player);
        HashMap pCache = new HashMap();
        IDatabase questDB = QuestingAPI.getAPI(ApiReference.QUEST_DB);
        for (DBEntry entry : idList = questDB.getEntries()) {
            IQuest quest = (IQuest)questDB.getValue(entry.getID());
            if (quest == null || !quest.isUnlocked(uuid) && !quest.getProperties().getProperty(NativeProps.LOCKED_PROGRESS).booleanValue() || !quest.canSubmit(player) && quest.getProperties().getProperty(NativeProps.REPEAT_TIME) < 0 && (!quest.getProperties().getProperty(NativeProps.AUTO_CLAIM).booleanValue() || quest.hasClaimed(uuid))) continue;
            ArrayList<Integer> tList = new ArrayList<Integer>();
            for (DBEntry task : quest.getTasks().getEntries()) {
                if (((ITask)task.getValue()).isComplete(uuid)) continue;
                tList.add(task.getID());
            }
            pCache.put(entry.getID(), tList);
        }
        this.rawCache.put(uuid, pCache);
    }

    public List<IQuest> getActiveQuests(UUID uuid) {
        ArrayList<IQuest> list = new ArrayList<IQuest>();
        HashMap pCache = this.rawCache.get(uuid);
        pCache = pCache != null ? pCache : new HashMap();
        Iterator iterator = pCache.keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            IQuest quest = (IQuest)QuestingAPI.getAPI(ApiReference.QUEST_DB).getValue(id);
            if (quest == null) continue;
            list.add(quest);
        }
        return list;
    }

    public Map<ITask, IQuest> getActiveTasks(UUID uuid) {
        return this.getActiveTasks(uuid, ITask.class);
    }

    public <T extends ITask> Map<T, IQuest> getActiveTasks(UUID uuid, Class<T> type) {
        HashMap<ITask, IQuest> list = new HashMap<ITask, IQuest>();
        HashMap pCache = this.rawCache.get(uuid);
        pCache = pCache != null ? pCache : new HashMap();
        for (Map.Entry entry : pCache.entrySet()) {
            IQuest quest = (IQuest)QuestingAPI.getAPI(ApiReference.QUEST_DB).getValue((Integer)entry.getKey());
            if (quest == null) continue;
            Iterator iterator = ((List)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                int tID = (Integer)iterator.next();
                ITask task = (ITask)quest.getTasks().getValue(tID);
                if (task == null || !type.isAssignableFrom(task.getClass())) continue;
                list.put(task, quest);
            }
        }
        return list;
    }

    public void reset() {
        this.rawCache.clear();
    }
}

