/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.structures.lib;

import com.google.common.base.Functions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.structurize.blockout.Log;
import com.structurize.coremod.blocks.interfaces.IAnchorBlock;
import com.structurize.structures.client.TemplateBlockAccess;
import com.structurize.structures.client.TemplateBlockAccessTransformHandler;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;

public final class TemplateUtils {
    private static final Cache<Template, Map<BlockPos, Template.BlockInfo>> templateBlockInfoCache = CacheBuilder.newBuilder().maximumSize(50L).build();

    private TemplateUtils() {
        throw new IllegalArgumentException("Utils class");
    }

    public static TileEntity getTileEntityFromPos(Template template, BlockPos pos, TemplateBlockAccess access) {
        Template.BlockInfo blockInfo = TemplateUtils.getBlockInfoFromPos(template, pos);
        if (blockInfo.field_186244_c != null) {
            return TileEntity.func_190200_a((World)access, (NBTTagCompound)blockInfo.field_186244_c);
        }
        return null;
    }

    public static Template.BlockInfo getBlockInfoFromPos(Template template, BlockPos pos) {
        try {
            return TemplateBlockAccessTransformHandler.getInstance().Transform(Optional.ofNullable(((Map)templateBlockInfoCache.get((Object)template, () -> template.field_186270_a.stream().collect(Collectors.toMap(bi -> bi.field_186242_a, Functions.identity())))).get(pos)).orElse(new Template.BlockInfo(pos, Blocks.field_150350_a.func_176223_P(), null)));
        }
        catch (ExecutionException e) {
            Log.getLogger().warn((Object)e);
            return new Template.BlockInfo(pos, Blocks.field_150350_a.func_176223_P(), null);
        }
    }

    public static BlockPos getPrimaryBlockOffset(@NotNull Template template) {
        return template.field_186270_a.stream().filter(blockInfo -> blockInfo.field_186243_b.func_177230_c() instanceof IAnchorBlock).findFirst().map(blockInfo -> TemplateBlockAccessTransformHandler.getInstance().Transform((Template.BlockInfo)blockInfo)).map(blockInfo -> blockInfo.field_186242_a).orElse(new BlockPos(template.func_186259_a().func_177958_n() / 2, 0, template.func_186259_a().func_177952_p() / 2));
    }
}

