/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.structures.helpers;

import com.structurize.api.util.BlockPosUtil;
import com.structurize.coremod.blocks.interfaces.IAnchorBlock;
import com.structurize.structures.helpers.Structure;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureProxy {
    private final Structure structure;
    private Template.EntityInfo[][][] entities;
    private Template.BlockInfo[][][] blocks;
    private int width;
    private int height;
    private int length;
    private BlockPos offset;

    public StructureProxy(World worldObj, String name) {
        this.structure = new Structure(worldObj, name, new PlacementSettings());
        if (this.structure.isTemplateMissing()) {
            return;
        }
        BlockPos size = this.structure.getSize(Rotation.NONE);
        this.width = size.func_177958_n();
        this.height = size.func_177956_o();
        this.length = size.func_177952_p();
        this.blocks = new Template.BlockInfo[this.width][this.height][this.length];
        this.entities = new Template.EntityInfo[this.width][this.height][this.length];
        for (Template.BlockInfo info : this.structure.getBlockInfo()) {
            BlockPos tempPos = info.field_186242_a;
            this.blocks[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = info;
            this.entities[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = null;
            if (!(info.field_186243_b.func_177230_c() instanceof IAnchorBlock)) continue;
            this.offset = info.field_186242_a;
        }
        for (Template.EntityInfo info : this.structure.getTileEntities()) {
            if (info.field_186249_c.func_74779_i("id").equals("minecraft:item")) continue;
            BlockPos tempPos = info.field_186248_b;
            this.entities[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = info;
        }
    }

    public StructureProxy(Structure structure) {
        this.structure = structure;
        if (structure.isTemplateMissing()) {
            return;
        }
        BlockPos size = structure.getSize(Rotation.NONE);
        this.width = size.func_177958_n();
        this.height = size.func_177956_o();
        this.length = size.func_177952_p();
        this.blocks = new Template.BlockInfo[this.width][this.height][this.length];
        this.entities = new Template.EntityInfo[this.width][this.height][this.length];
        for (Template.BlockInfo info : structure.getBlockInfo()) {
            BlockPos tempPos = info.field_186242_a;
            this.blocks[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = info;
            this.entities[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = null;
        }
        for (Template.EntityInfo info : structure.getTileEntities()) {
            if (info.field_186249_c.func_74779_i("id").equals("minecraft:item")) continue;
            BlockPos tempPos = info.field_186248_b;
            this.entities[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = info;
        }
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public void setOffset(BlockPos pos) {
        this.offset = pos;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public IBlockState getBlockState(@NotNull BlockPos pos) {
        if (this.blocks.length <= pos.func_177958_n() || this.blocks[pos.func_177958_n()].length <= pos.func_177956_o() || this.blocks[pos.func_177958_n()][pos.func_177956_o()].length <= pos.func_177952_p()) {
            return null;
        }
        return this.blocks[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()].field_186243_b;
    }

    public Template.BlockInfo getBlockInfo(@NotNull BlockPos pos) {
        if (this.blocks.length <= pos.func_177958_n() || this.blocks[pos.func_177958_n()].length <= pos.func_177956_o() || this.blocks[pos.func_177958_n()][pos.func_177956_o()].length <= pos.func_177952_p()) {
            return null;
        }
        return this.blocks[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()];
    }

    public List<Template.EntityInfo> getTileEntities() {
        return this.structure.getTileEntities();
    }

    @Nullable
    public Template.EntityInfo getEntityinfo(@NotNull BlockPos pos) {
        if (this.entities.length <= pos.func_177958_n() || this.entities[pos.func_177958_n()].length <= pos.func_177956_o() || this.entities[pos.func_177958_n()][pos.func_177956_o()].length <= pos.func_177952_p()) {
            return null;
        }
        return this.entities[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()];
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    public void rotateWithMirror(int times, World world, BlockPos rotatePos, Mirror mirror) {
        BlockPos temp;
        Rotation rotation = BlockPosUtil.getRotationFromRotations(times);
        this.structure.setPlacementSettings(new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror));
        BlockPos size = this.structure.getSize(rotation);
        this.width = size.func_177958_n();
        this.height = size.func_177956_o();
        this.length = size.func_177952_p();
        this.blocks = new Template.BlockInfo[this.width][this.height][this.length];
        this.entities = new Template.EntityInfo[this.width][this.height][this.length];
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        for (Template.BlockInfo info : this.structure.getBlockInfoWithSettings(new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror))) {
            BlockPos tempPos = info.field_186242_a;
            int x = tempPos.func_177958_n();
            int y = tempPos.func_177956_o();
            int z = tempPos.func_177952_p();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z >= minZ) continue;
            minZ = z;
        }
        minX = Math.abs(minX);
        minY = Math.abs(minY);
        minZ = Math.abs(minZ);
        boolean foundAnchor = false;
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror);
        for (Template.BlockInfo info : this.structure.getBlockInfoWithSettings(settings)) {
            TileEntity entity;
            BlockPos tempPos = info.field_186242_a;
            int x = tempPos.func_177958_n() + minX;
            int y = tempPos.func_177956_o() + minY;
            int z = tempPos.func_177952_p() + minZ;
            this.blocks[x][y][z] = info;
            this.entities[x][y][z] = null;
            if (info.field_186243_b.func_177230_c() instanceof IAnchorBlock) {
                foundAnchor = true;
                this.offset = info.field_186242_a.func_177982_a(minX, minY, minZ);
            }
            if (info.field_186244_c == null || (entity = TileEntity.func_190200_a((World)world, (NBTTagCompound)info.field_186244_c)) == null) continue;
            entity.func_189667_a(rotation);
            entity.func_189668_a(mirror);
            this.blocks[x][y][z] = new Template.BlockInfo(info.field_186242_a, info.field_186243_b, entity.func_189515_b(new NBTTagCompound()));
        }
        if (mirror.equals((Object)Mirror.FRONT_BACK)) {
            temp = minX == minZ ? new BlockPos(size.func_177958_n(), size.func_177956_o(), minZ > 0 ? -size.func_177952_p() : size.func_177952_p()) : new BlockPos(minX > 0 ? -size.func_177958_n() : size.func_177958_n(), size.func_177956_o(), minZ > 0 ? -size.func_177952_p() : size.func_177952_p());
            temp = temp.func_190942_a(rotation);
        } else {
            temp = size;
        }
        if (!foundAnchor) {
            this.updateOffSetIfDecoration(temp, times, minX, minY, minZ);
        }
        for (Template.EntityInfo info : this.structure.getTileEntities()) {
            if (info.field_186249_c.func_74779_i("id").equals("minecraft:item")) continue;
            Template.EntityInfo newInfo = this.structure.transformEntityInfoWithSettings(info, world, rotatePos.func_177973_b((Vec3i)this.offset).func_177971_a((Vec3i)new BlockPos(minX, minY, minZ)), settings);
            BlockPos tempPos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)info.field_186248_b);
            int x = tempPos.func_177958_n() + minX;
            int y = tempPos.func_177956_o() + minY;
            int z = tempPos.func_177952_p() + minZ;
            this.entities[x][y][z] = newInfo;
        }
    }

    private void updateOffSetIfDecoration(BlockPos size, int rotation, int minX, int minY, int minZ) {
        BlockPos tempSize = size;
        if (rotation == 1) {
            tempSize = new BlockPos(-size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
        }
        if (rotation == 2) {
            tempSize = new BlockPos(-size.func_177958_n(), size.func_177956_o(), -size.func_177952_p());
        }
        if (rotation == 3) {
            tempSize = new BlockPos(size.func_177958_n(), size.func_177956_o(), -size.func_177952_p());
        }
        this.offset = new BlockPos(tempSize.func_177958_n() / 2, 0, tempSize.func_177952_p() / 2).func_177982_a(minX, minY, minZ);
    }
}

