/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.structures.helpers;

import com.google.common.collect.ImmutableList;
import com.structurize.api.configuration.Configurations;
import com.structurize.api.util.Log;
import com.structurize.coremod.Structurize;
import com.structurize.coremod.management.Manager;
import com.structurize.coremod.management.StructureName;
import com.structurize.coremod.management.Structures;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;

public class Structure {
    private static final double NINETY_DEGREES = 90.0;
    private static final int BUFFER_SIZE = 1024;
    private final DataFixer fixer;
    public static List<String> originFolders = new ArrayList<String>();
    private Template template;
    private PlacementSettings settings;
    private String md5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Structure(@Nullable World world, String structureName, PlacementSettings settings) {
        InputStream inputStream;
        String correctStructureName;
        block8: {
            correctStructureName = structureName;
            if (world == null || world.field_72995_K) {
                this.settings = settings;
            }
            this.fixer = DataFixesManager.func_188279_a();
            inputStream = null;
            try {
                if (Structures.hasMD5(correctStructureName) && (inputStream = Structure.getStream("cache/" + Structures.getMD5(correctStructureName))) != null) {
                    correctStructureName = "cache/" + Structures.getMD5(correctStructureName);
                }
                if (inputStream == null) {
                    inputStream = Structure.getStream(correctStructureName);
                }
                if (inputStream != null) break block8;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return;
        }
        try {
            this.md5 = Structure.calculateMD5(Structure.getStream(correctStructureName));
            this.template = Structure.readTemplateFromStream(inputStream, this.fixer);
        }
        catch (IOException e) {
            Log.getLogger().warn(String.format("Failed to load template %s", correctStructureName), (Throwable)e);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    @Nullable
    public static InputStream getStream(String structureName) {
        InputStream inputstream;
        block5: {
            StructureName sn;
            block6: {
                block4: {
                    sn = new StructureName(structureName);
                    inputstream = null;
                    if (!"cache".equals(sn.getPrefix())) break block4;
                    for (File cachedFile : Structure.getCachedSchematicsFolders()) {
                        InputStream stream = Structure.getStreamFromFolder(cachedFile, structureName);
                        if (stream == null) continue;
                        return stream;
                    }
                    break block5;
                }
                if (!"scans".equals(sn.getPrefix())) break block6;
                for (File cachedFile : Structure.getClientSchematicsFolders()) {
                    InputStream stream = Structure.getStreamFromFolder(cachedFile, structureName);
                    if (stream == null) continue;
                    return stream;
                }
                break block5;
            }
            if (!"schematics".equals(sn.getPrefix())) {
                return null;
            }
            inputstream = Structure.getStreamFromFolder(Structurize.proxy.getSchematicsFolder(), structureName);
            if (inputstream != null || Configurations.gameplay.ignoreSchematicsFromJar) break block5;
            for (InputStream stream : Structure.getStreamsFromJar(structureName)) {
                if (stream == null) continue;
                inputstream = stream;
            }
        }
        return inputstream;
    }

    public static String calculateMD5(InputStream stream) {
        if (stream == null) {
            Log.getLogger().error("Structure.calculateMD5: stream is null, this should not happen");
            return null;
        }
        return Structure.calculateMD5(Structure.getStreamAsByteArray(stream));
    }

    private static Template readTemplateFromStream(InputStream stream, DataFixer fixer) throws IOException {
        NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        if (!nbttagcompound.func_150297_b("DataVersion", 99)) {
            nbttagcompound.func_74768_a("DataVersion", 500);
        }
        Template template = new Template();
        ModFixs fixs = ((CompoundDataFixer)fixer).init("structurize", 1);
        fixs.registerFix((IFixType)FixTypes.STRUCTURE, new IFixableData(){

            public int func_188216_a() {
                return 1;
            }

            public NBTTagCompound func_188217_a(NBTTagCompound compound) {
                if (compound.func_74764_b("palette")) {
                    NBTTagList list = compound.func_150295_c("palette", 10);
                    for (NBTBase listCompound : list) {
                        String structurizeName;
                        String name;
                        if (!(listCompound instanceof NBTTagCompound) || !((NBTTagCompound)listCompound).func_74764_b("Name") || !(name = ((NBTTagCompound)listCompound).func_74779_i("Name")).contains("minecolonies") || Block.func_149684_b((String)name) != null || Block.func_149684_b((String)(structurizeName = "structurize" + name.substring("minecolonies".length()))) == null) continue;
                        ((NBTTagCompound)listCompound).func_74778_a("Name", structurizeName);
                    }
                }
                return compound;
            }
        });
        template.func_186256_b(fixer.func_188257_a((IFixType)FixTypes.STRUCTURE, nbttagcompound));
        return template;
    }

    @Nullable
    private static InputStream getStreamFromFolder(@Nullable File folder, String structureName) {
        if (folder == null) {
            return null;
        }
        File nbtFile = new File(folder.getPath() + "/" + structureName + ".nbt");
        try {
            if (folder.exists()) {
                if (!nbtFile.toURI().normalize().getPath().startsWith(folder.toURI().normalize().getPath())) {
                    Log.getLogger().error("Structure: Illegal structure name \"" + structureName + "\"");
                    return null;
                }
                if (nbtFile.exists()) {
                    return new FileInputStream(nbtFile);
                }
            }
        }
        catch (FileNotFoundException e) {
            Log.getLogger().error("Structure.getStreamFromFolder", (Throwable)e);
        }
        return null;
    }

    public static List<File> getCachedSchematicsFolders() {
        ArrayList<File> cachedSchems = new ArrayList<File>();
        for (String origin : originFolders) {
            if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
                if (Manager.getServerUUID() != null) {
                    cachedSchems.add(new File(Minecraft.func_71410_x().field_71412_D, origin + "/" + Manager.getServerUUID()));
                    continue;
                }
                Log.getLogger().error("Manager.getServerUUID() => null this should not happen");
                return null;
            }
            cachedSchems.add(new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n() + "/" + "structurize"));
        }
        return cachedSchems;
    }

    public static List<File> getClientSchematicsFolders() {
        ArrayList<File> clientSchems = new ArrayList<File>();
        for (String origin : originFolders) {
            clientSchems.add(new File(Minecraft.func_71410_x().field_71412_D, origin));
        }
        return clientSchems;
    }

    private static List<InputStream> getStreamsFromJar(String structureName) {
        ArrayList<InputStream> streamsFromJar = new ArrayList<InputStream>();
        for (String origin : originFolders) {
            streamsFromJar.add(MinecraftServer.class.getResourceAsStream("/assets/" + origin + '/' + structureName + ".nbt"));
        }
        return streamsFromJar;
    }

    public static String calculateMD5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return DatatypeConverter.printHexBinary((byte[])md.digest(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            Log.getLogger().trace((Object)e);
            return null;
        }
    }

    public static byte[] getStreamAsByteArray(InputStream stream) {
        if (stream == null) {
            Log.getLogger().info("Structure.getStreamAsByteArray: stream is null this should not happen");
            return new byte[0];
        }
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
        catch (IOException e) {
            Log.getLogger().trace((Object)e);
            return new byte[0];
        }
    }

    public Structure(@Nullable World world) {
        this.fixer = DataFixesManager.func_188279_a();
    }

    public static byte[] compress(byte[] data) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(data.length);
        try (GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
            zipStream.write(data);
        }
        catch (IOException e) {
            Log.getLogger().error("Could not compress the data", (Throwable)e);
        }
        return byteStream.toByteArray();
    }

    public static byte[] uncompress(byte[] data) {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
             GZIPInputStream zipStream = new GZIPInputStream(byteStream);){
            int len;
            while ((len = zipStream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            Log.getLogger().warn("Could not uncompress data", (Throwable)e);
        }
        return out.toByteArray();
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public boolean isCorrectMD5(String otherMD5) {
        Log.getLogger().info("isCorrectMD5: md5:" + this.md5 + " other:" + otherMD5);
        if (this.md5 == null || otherMD5 == null) {
            return false;
        }
        return this.md5.compareTo(otherMD5) == 0;
    }

    public boolean isTemplateMissing() {
        return this.template == null;
    }

    public Template.BlockInfo[] getBlockInfo() {
        Template.BlockInfo[] blockList = new Template.BlockInfo[this.template.field_186270_a.size()];
        blockList = this.template.field_186270_a.toArray(blockList);
        return blockList;
    }

    public Entity[] getEntityInfo(World world, BlockPos pos) {
        Template.EntityInfo[] entityInfoList = new Template.EntityInfo[this.template.field_186271_b.size()];
        entityInfoList = this.template.field_186270_a.toArray(entityInfoList);
        Entity[] entityList = null;
        for (int i = 0; i < entityInfoList.length; ++i) {
            Entity finalEntity = EntityList.func_75615_a((NBTTagCompound)entityInfoList[i].field_186249_c, (World)world);
            Vec3d entityVec = entityInfoList[i].field_186247_a.func_178787_e(new Vec3d((Vec3i)pos));
            finalEntity.func_70107_b(entityVec.field_72450_a, entityVec.field_72448_b, entityVec.field_72449_c);
        }
        return entityList;
    }

    public BlockPos getSize(Rotation rotation) {
        return this.template.func_186257_a(rotation);
    }

    public void setPlacementSettings(PlacementSettings settings) {
        this.settings = settings;
    }

    public ImmutableList<Template.BlockInfo> getBlockInfoWithSettings(PlacementSettings settings) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.template.field_186270_a.forEach(blockInfo -> {
            IBlockState finalState = blockInfo.field_186243_b.func_185902_a(settings.func_186212_b()).func_185907_a(settings.func_186215_c());
            BlockPos finalPos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)blockInfo.field_186242_a);
            Template.BlockInfo finalInfo = new Template.BlockInfo(finalPos, finalState, blockInfo.field_186244_c);
            builder.add((Object)finalInfo);
        });
        return builder.build();
    }

    public Template.EntityInfo transformEntityInfoWithSettings(Template.EntityInfo entityInfo, World world, BlockPos pos, PlacementSettings settings) {
        Entity finalEntity = EntityList.func_75615_a((NBTTagCompound)entityInfo.field_186249_c, (World)world);
        Vec3d entityVec = Structure.transformedVec3d(settings, entityInfo.field_186247_a).func_178787_e(new Vec3d((Vec3i)pos));
        if (finalEntity != null) {
            finalEntity.field_70126_B = (float)((double)finalEntity.func_184217_a(settings.func_186212_b()) - 90.0);
            double rotationYaw = (double)finalEntity.func_184217_a(settings.func_186212_b()) + ((double)finalEntity.field_70177_z - (double)finalEntity.func_184229_a(settings.func_186215_c()));
            finalEntity.func_70012_b(entityVec.field_72450_a, entityVec.field_72448_b, entityVec.field_72449_c, (float)rotationYaw, finalEntity.field_70125_A);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            finalEntity.func_70039_c(nbttagcompound);
            return new Template.EntityInfo(entityInfo.field_186247_a, entityInfo.field_186248_b, nbttagcompound);
        }
        return null;
    }

    public static Vec3d transformedVec3d(PlacementSettings settings, Vec3d vec) {
        Mirror mirrorIn = settings.func_186212_b();
        Rotation rotationIn = settings.func_186215_c();
        double xCoord = vec.field_72450_a;
        double yCoord = vec.field_72448_b;
        double zCoord = vec.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                zCoord = 1.0 - zCoord;
                break;
            }
            case FRONT_BACK: {
                xCoord = 1.0 - xCoord;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(zCoord, yCoord, 1.0 - xCoord);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - zCoord, yCoord, xCoord);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - xCoord, yCoord, 1.0 - zCoord);
            }
        }
        return flag ? new Vec3d(xCoord, yCoord, zCoord) : vec;
    }

    public List<Template.EntityInfo> getTileEntities() {
        return this.template.field_186271_b;
    }

    public PlacementSettings getSettings() {
        return this.settings;
    }
}

