/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.structures.client;

import com.structurize.structures.lib.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.VertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class TemplateTessellator {
    private static final int VERTEX_COMPONENT_SIZE = 3;
    private static final int COLOR_COMPONENT_SIZE = 4;
    private static final int TEX_COORD_COMPONENT_SIZE = 2;
    private static final int LIGHT_TEX_COORD_COMPONENT_SIZE = 2;
    private static final int VERTEX_SIZE = 28;
    private static final int VERTEX_COMPONENT_OFFSET = 0;
    private static final int COLOR_COMPONENT_OFFSET = 12;
    private static final int TEX_COORD_COMPONENT_OFFSET = 16;
    private static final int LIGHT_TEXT_COORD_COMPONENT_OFFSET = 24;
    private static final float HALF_PERCENT_SHRINK = 0.995f;
    private static final int DEFAULT_BUFFER_SIZE = 0x200000;
    private final BufferBuilder builder;
    private final VertexBuffer buffer = new VertexBuffer(DefaultVertexFormats.field_176600_a);
    private final VertexBufferUploader vboUploader = new VertexBufferUploader();
    private boolean isReadOnly = false;

    public TemplateTessellator() {
        this.builder = new BufferBuilder(0x200000);
        this.vboUploader.func_178178_a(this.buffer);
    }

    public void draw(Rotation rotation, Mirror mirror, Vector3d drawingOffset, BlockPos inTemplateOffset) {
        if (!this.isReadOnly) {
            this.builder.func_178977_d();
            this.vboUploader.func_181679_a(this.builder);
            this.isReadOnly = true;
        }
        TemplateTessellator.preTemplateBufferBinding(rotation, mirror, drawingOffset, inTemplateOffset);
        this.buffer.func_177359_a();
        TemplateTessellator.preTemplateDraw();
        this.buffer.func_177358_a(7);
        this.postTemplateDraw();
        this.buffer.func_177361_b();
        this.postTemplateBufferUnbinding();
    }

    private static void preTemplateBufferBinding(Rotation rotation, Mirror mirror, Vector3d drawingOffset, BlockPos inTemplateOffset) {
        TextureMap textureObject = Minecraft.func_71410_x().func_147117_R();
        GlStateManager.func_179144_i((int)textureObject.func_110552_b());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)drawingOffset.field_181059_a, (double)drawingOffset.field_181060_b, (double)drawingOffset.field_181061_c);
        BlockPos rotateInTemplateOffset = inTemplateOffset.func_190942_a(rotation);
        GlStateManager.func_179109_b((float)(-rotateInTemplateOffset.func_177958_n()), (float)(-rotateInTemplateOffset.func_177956_o()), (float)(-rotateInTemplateOffset.func_177952_p()));
        RenderUtil.applyRotationToYAxis(rotation);
        RenderUtil.applyMirror(mirror, inTemplateOffset);
        GlStateManager.func_179152_a((float)0.995f, (float)0.995f, (float)0.995f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179117_G();
        GlStateManager.func_179094_E();
    }

    private static void preTemplateDraw() {
        GlStateManager.func_187410_q((int)32884);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32886);
        GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
        GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
        GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179129_p();
    }

    private void postTemplateDraw() {
        GlStateManager.func_179089_o();
        for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
            VertexFormatElement.EnumUsage vfeUsage = vertexformatelement.func_177375_c();
            int formatIndex = vertexformatelement.func_177369_e();
            switch (vfeUsage) {
                case POSITION: {
                    GlStateManager.func_187429_p((int)32884);
                    break;
                }
                case UV: {
                    OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + formatIndex));
                    GlStateManager.func_187429_p((int)32888);
                    OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                    break;
                }
                case COLOR: {
                    GlStateManager.func_187429_p((int)32886);
                    GlStateManager.func_179117_G();
                    break;
                }
            }
        }
    }

    private void postTemplateBufferUnbinding() {
        GlStateManager.func_179121_F();
        GlStateManager.func_179117_G();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public BufferBuilder getBuilder() {
        if (this.isReadOnly) {
            throw new IllegalStateException("Cannot retrieve BufferBuilder when Tessellator is in readonly.");
        }
        return this.builder;
    }

    public VertexBuffer getBuffer() {
        return this.buffer;
    }
}

