/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.structures.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.structurize.api.util.Log;
import com.structurize.structures.client.TemplateBlockAccess;
import com.structurize.structures.client.TemplateBlockAccessTransformHandler;
import com.structurize.structures.client.TemplateTessellator;
import com.structurize.structures.lib.TemplateUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.Nullable;

public final class TemplateRenderHandler {
    private static final TemplateRenderHandler ourInstance = new TemplateRenderHandler();
    private final Cache<Template, TemplateTessellator> templateBufferBuilderCache = CacheBuilder.newBuilder().maximumSize(50L).removalListener(notification -> ((TemplateTessellator)notification.getValue()).getBuffer().func_177362_c()).build();
    private BlockRendererDispatcher rendererDispatcher;
    private RenderManager entityRenderer;

    private TemplateRenderHandler() {
    }

    public static TemplateRenderHandler getInstance() {
        return ourInstance;
    }

    public void draw(Template template, Rotation rotation, Mirror mirror, Vector3d drawingOffset, float partialTicks, BlockPos pos) {
        if (this.rendererDispatcher == null) {
            this.rendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
        }
        if (this.entityRenderer == null) {
            this.entityRenderer = Minecraft.func_71410_x().func_175598_ae();
        }
        TemplateBlockAccess blockAccess = new TemplateBlockAccess(template);
        try {
            ((TemplateTessellator)this.templateBufferBuilderCache.get((Object)template, () -> {
                TemplateTessellator tessellator = new TemplateTessellator();
                tessellator.getBuilder().func_181668_a(7, DefaultVertexFormats.field_176600_a);
                template.field_186270_a.stream().map(b -> TemplateBlockAccessTransformHandler.getInstance().Transform((Template.BlockInfo)b)).forEach(b -> this.rendererDispatcher.func_175018_a(b.field_186243_b, b.field_186242_a, (IBlockAccess)blockAccess, tessellator.getBuilder()));
                return tessellator;
            })).draw(rotation, mirror, drawingOffset, TemplateUtils.getPrimaryBlockOffset(template));
            template.field_186270_a.stream().filter(blockInfo -> blockInfo.field_186244_c != null).map(b -> this.constructTileEntities((Template.BlockInfo)b, pos.func_177973_b((Vec3i)TemplateUtils.getPrimaryBlockOffset(template)))).filter(Objects::nonNull).forEach(tileEntity -> TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, 0));
        }
        catch (ExecutionException e) {
            Log.getLogger().error((Object)e);
        }
    }

    @Nullable
    private TileEntity constructTileEntities(Template.BlockInfo info, BlockPos pos) {
        TileEntity entity = TileEntity.func_190200_a(null, (NBTTagCompound)info.field_186244_c);
        if (!(entity instanceof TileEntityBanner)) {
            return null;
        }
        entity.func_174878_a(pos.func_177971_a((Vec3i)info.field_186242_a));
        return entity;
    }

    public void drawTemplateAtListOfPositions(List<BlockPos> points, float partialTicks, Template template) {
        if (points.isEmpty()) {
            return;
        }
        EntityPlayerSP perspectiveEntity = Minecraft.func_71410_x().field_71439_g;
        double interpolatedEntityPosX = perspectiveEntity.field_70142_S + (perspectiveEntity.field_70165_t - perspectiveEntity.field_70142_S) * (double)partialTicks;
        double interpolatedEntityPosY = perspectiveEntity.field_70137_T + (perspectiveEntity.field_70163_u - perspectiveEntity.field_70137_T) * (double)partialTicks;
        double interpolatedEntityPosZ = perspectiveEntity.field_70136_U + (perspectiveEntity.field_70161_v - perspectiveEntity.field_70136_U) * (double)partialTicks;
        for (BlockPos coord : points) {
            BlockPos pos = coord.func_177977_b();
            double renderOffsetX = (double)pos.func_177958_n() - interpolatedEntityPosX;
            double renderOffsetY = (double)pos.func_177956_o() - interpolatedEntityPosY;
            double renderOffsetZ = (double)pos.func_177952_p() - interpolatedEntityPosZ;
            Vector3d renderOffset = new Vector3d();
            renderOffset.field_181059_a = renderOffsetX;
            renderOffset.field_181060_b = renderOffsetY;
            renderOffset.field_181061_c = renderOffsetZ;
            this.draw(template, Rotation.NONE, Mirror.NONE, renderOffset, partialTicks, coord);
        }
    }
}

