/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.structures.client;

import com.structurize.structures.client.TemplateRenderHandler;
import com.structurize.structures.helpers.Structure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructureClientHandler {
    private StructureClientHandler() {
        throw new IllegalArgumentException("Utility class");
    }

    public static void renderStructure(@NotNull Structure structure, float partialTicks, BlockPos pos) {
        StructureClientHandler.renderStructure(structure, (Entity)Minecraft.func_71410_x().field_71439_g, partialTicks, pos);
    }

    public static void renderStructure(@NotNull Structure structure, @Nullable Entity perspectiveEntity, float partialTicks, BlockPos pos) {
        if (perspectiveEntity != null) {
            double interpolatedEntityPosX = perspectiveEntity.field_70142_S + (perspectiveEntity.field_70165_t - perspectiveEntity.field_70142_S) * (double)partialTicks;
            double interpolatedEntityPosY = perspectiveEntity.field_70137_T + (perspectiveEntity.field_70163_u - perspectiveEntity.field_70137_T) * (double)partialTicks;
            double interpolatedEntityPosZ = perspectiveEntity.field_70136_U + (perspectiveEntity.field_70161_v - perspectiveEntity.field_70136_U) * (double)partialTicks;
            double renderOffsetX = (double)pos.func_177958_n() - interpolatedEntityPosX;
            double renderOffsetY = (double)pos.func_177956_o() - interpolatedEntityPosY;
            double renderOffsetZ = (double)pos.func_177952_p() - interpolatedEntityPosZ;
            Vector3d renderOffset = new Vector3d();
            renderOffset.field_181059_a = renderOffsetX;
            renderOffset.field_181060_b = renderOffsetY;
            renderOffset.field_181061_c = renderOffsetZ;
            TemplateRenderHandler.getInstance().draw(structure.getTemplate(), structure.getSettings().func_186215_c(), structure.getSettings().func_186212_b(), renderOffset, partialTicks, pos);
        }
    }
}

