/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.util;

import com.structurize.api.configuration.Configurations;
import com.structurize.api.util.BlockPosUtil;
import com.structurize.api.util.BlockUtils;
import com.structurize.api.util.ChangeStorage;
import com.structurize.api.util.ItemStackUtils;
import com.structurize.api.util.Log;
import com.structurize.coremod.blocks.ModBlocks;
import com.structurize.coremod.blocks.interfaces.IAnchorBlock;
import com.structurize.coremod.management.Manager;
import com.structurize.coremod.placementhandlers.IPlacementHandler;
import com.structurize.coremod.placementhandlers.PlacementHandlers;
import com.structurize.coremod.util.ScanToolOperation;
import com.structurize.structures.helpers.Structure;
import com.structurize.structures.helpers.StructureProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureWrapper {
    protected static final BlockPos NULL_POS = new BlockPos(-1, -1, -1);
    protected final BlockPos.MutableBlockPos progressPos = new BlockPos.MutableBlockPos(-1, -1, -1);
    protected final World world;
    protected final StructureProxy structure;
    protected final String name;
    protected BlockPos position;
    private boolean complete = false;

    public StructureWrapper(World worldObj, String name) {
        this(worldObj, new StructureProxy(worldObj, name), name);
    }

    protected StructureWrapper(World worldObj, StructureProxy structure, String name) {
        this.world = worldObj;
        this.structure = structure;
        this.name = name;
    }

    public static void unloadStructure(@NotNull World world, @NotNull BlockPos pos, @NotNull String first, int rotation, @NotNull Mirror mirror) {
        StructureWrapper structureWrapper = new StructureWrapper(world, first);
        structureWrapper.position = pos;
        structureWrapper.rotate(rotation, world, pos, mirror);
        structureWrapper.removeStructure(pos.func_177973_b((Vec3i)structureWrapper.getOffset()));
    }

    private void removeStructure(@NotNull BlockPos pos) {
        this.setLocalPosition(pos);
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    BlockPos localPos = new BlockPos(i, j, k);
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    if (this.world.func_175623_d(worldPos)) continue;
                    this.world.func_175698_g(worldPos);
                }
            }
        }
    }

    public static void loadAndPlaceShapeWithRotation(WorldServer worldObj, Template template, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror, EntityPlayerMP player) {
        try {
            Structure structure = new Structure((World)worldObj);
            StructureProxy proxy = new StructureProxy(structure);
            structure.setTemplate(template);
            structure.setPlacementSettings(new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE));
            StructureWrapper structureWrapper = new StructureWrapper((World)worldObj, proxy, "shape" + player.func_70005_c_() + ".nbt");
            structureWrapper.position = pos;
            structureWrapper.rotate(rotations, (World)worldObj, pos, mirror);
            structureWrapper.setupStructurePlacement(pos.func_177973_b((Vec3i)structureWrapper.getOffset()), false, player);
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public static void loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror, boolean complete, EntityPlayerMP player) {
        try {
            StructureWrapper structureWrapper = new StructureWrapper(worldObj, name);
            structureWrapper.position = pos;
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            structureWrapper.setupStructurePlacement(pos.func_177973_b((Vec3i)structureWrapper.getOffset()), complete, player);
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public void rotate(int times, @NotNull World world, @NotNull BlockPos rotatePos, @NotNull Mirror mirror) {
        this.structure.rotateWithMirror(times, world, rotatePos, mirror);
    }

    public void setupStructurePlacement(@NotNull BlockPos pos, boolean complete, EntityPlayerMP player) {
        this.setLocalPosition(pos);
        this.complete = complete;
        this.position = pos;
        Manager.addToQueue(new ScanToolOperation(this, (EntityPlayer)player));
    }

    public BlockPos placeStructure(World world, ChangeStorage storage, BlockPos inputPos, boolean complete) {
        BlockPos localPos;
        int z;
        int x;
        int y;
        this.setLocalPosition(inputPos);
        ArrayList<BlockPos> delayedBlocks = new ArrayList<BlockPos>();
        BlockPos endPos = new BlockPos(this.structure.getWidth(), this.structure.getHeight(), this.structure.getLength());
        BlockPos currentPos = inputPos;
        int count = 0;
        for (y = currentPos.func_177956_o(); y < endPos.func_177956_o(); ++y) {
            for (x = currentPos.func_177958_n(); x < endPos.func_177958_n(); ++x) {
                for (z = currentPos.func_177952_p(); z < endPos.func_177952_p(); ++z) {
                    localPos = new BlockPos(x, y, z);
                    IBlockState localState = this.structure.getBlockState(localPos);
                    Block localBlock = localState.func_177230_c();
                    BlockPos worldPos = this.position.func_177971_a((Vec3i)localPos);
                    if (localBlock == ModBlocks.blockSubstitution && !complete || localBlock instanceof IAnchorBlock) continue;
                    ++count;
                    storage.addPositionStorage(worldPos, world);
                    if (localState.func_185904_a().func_76220_a()) {
                        this.handleBlockPlacement(world, worldPos, localState, complete, this.structure.getBlockInfo((BlockPos)localPos).field_186244_c);
                    } else {
                        delayedBlocks.add(localPos);
                    }
                    if (count < Configurations.Gameplay.maxOperationsPerTick) continue;
                    this.handleDelayedBlocks(delayedBlocks, storage, world);
                    return new BlockPos(x, y, z);
                }
                currentPos = new BlockPos(x, y, 0);
            }
            currentPos = new BlockPos(0, y, 0);
        }
        currentPos = new BlockPos(0, 0, 0);
        this.handleDelayedBlocks(delayedBlocks, storage, world);
        for (y = currentPos.func_177956_o(); y < endPos.func_177956_o(); ++y) {
            for (x = currentPos.func_177958_n(); x < endPos.func_177958_n(); ++x) {
                for (z = currentPos.func_177952_p(); z < endPos.func_177952_p(); ++z) {
                    localPos = new BlockPos(x, y, z);
                    Template.EntityInfo info = this.structure.getEntityinfo(localPos);
                    if (info != null) {
                        try {
                            Entity entity = EntityList.func_75615_a((NBTTagCompound)info.field_186249_c, (World)world);
                            entity.func_184221_a(UUID.randomUUID());
                            world.func_72838_d(entity);
                            storage.addToBeKilledEntity(entity);
                        }
                        catch (RuntimeException e) {
                            Log.getLogger().info("Couldn't restore entitiy", (Throwable)e);
                        }
                    }
                    if (count < Configurations.Gameplay.maxOperationsPerTick) continue;
                    return new BlockPos(x, y, z);
                }
                currentPos = new BlockPos(x, y, 0);
            }
            currentPos = new BlockPos(0, y, 0);
        }
        return null;
    }

    private void handleDelayedBlocks(List<BlockPos> delayedBlocks, ChangeStorage storage, World world) {
        for (BlockPos coords : delayedBlocks) {
            IBlockState localState = this.structure.getBlockState(coords);
            BlockPos newWorldPos = this.position.func_177971_a((Vec3i)coords);
            storage.addPositionStorage(coords, world);
            this.handleBlockPlacement(world, newWorldPos, localState, this.complete, this.structure.getBlockInfo(coords) == null ? null : this.structure.getBlockInfo((BlockPos)coords).field_186244_c);
        }
    }

    public BlockPos getOffset() {
        return this.structure.getOffset();
    }

    public void handleBlockPlacement(World world, BlockPos pos, IBlockState localState, boolean complete, NBTTagCompound tileEntityData) {
        for (IPlacementHandler handlers : PlacementHandlers.handlers) {
            if (!handlers.canHandle(world, pos, localState)) continue;
            handlers.handle(world, pos, localState, tileEntityData, complete, this.position);
            return;
        }
    }

    public boolean incrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.func_181079_c(-1, 0, 0);
        }
        this.progressPos.func_181079_c(this.progressPos.func_177958_n() + 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p());
        if (this.progressPos.func_177958_n() == this.structure.getWidth()) {
            this.progressPos.func_181079_c(0, this.progressPos.func_177956_o(), this.progressPos.func_177952_p() + 1);
            if (this.progressPos.func_177952_p() == this.structure.getLength()) {
                this.progressPos.func_181079_c(this.progressPos.func_177958_n(), this.progressPos.func_177956_o() + 1, 0);
                if (this.progressPos.func_177956_o() == this.structure.getHeight()) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isStructureBlockEqualWorldBlock() {
        IBlockState structureBlockState = this.structure.getBlockState(this.getLocalPosition());
        Block structureBlock = structureBlockState.func_177230_c();
        if (structureBlock == ModBlocks.blockSubstitution) {
            return true;
        }
        BlockPos worldPos = this.getBlockPosition();
        IBlockState worldBlockState = this.world.func_180495_p(worldPos);
        if (structureBlock == ModBlocks.blockSolidSubstitution && worldBlockState.func_185904_a().func_76220_a()) {
            return true;
        }
        Block worldBlock = worldBlockState.func_177230_c();
        if (structureBlock instanceof BlockDoor || structureBlock == Blocks.field_150457_bL) {
            return structureBlock == worldBlock;
        }
        if (structureBlock instanceof BlockStairs && structureBlockState == worldBlockState || BlockUtils.isGrassOrDirt(structureBlock, worldBlock, structureBlockState, worldBlockState)) {
            return true;
        }
        Template.EntityInfo entityInfo = this.structure.getEntityinfo(this.getLocalPosition());
        if (entityInfo != null) {
            return false;
        }
        return worldPos.func_177956_o() <= 0 || structureBlockState == worldBlockState;
    }

    public void reset() {
        BlockPosUtil.set(this.progressPos, NULL_POS);
    }

    @NotNull
    public BlockPos getLocalPosition() {
        return this.progressPos.func_185334_h();
    }

    public void setLocalPosition(@NotNull BlockPos localPosition) {
        BlockPosUtil.set(this.progressPos, localPosition);
    }

    public BlockPos getBlockPosition() {
        return this.progressPos.func_177971_a((Vec3i)this.getOffsetPosition());
    }

    public BlockPos getOffsetPosition() {
        return this.position.func_177973_b((Vec3i)this.getOffset());
    }

    @Nullable
    public IBlockState getBlockState() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getBlockState((BlockPos)this.progressPos);
    }

    @NotNull
    public List<Template.EntityInfo> getEntities() {
        return this.structure.getTileEntities();
    }

    public BlockPos getPosition() {
        if (this.position == null) {
            return new BlockPos(0, 0, 0);
        }
        return this.position;
    }

    public void setPosition(BlockPos position) {
        this.position = position;
    }

    @Nullable
    public Item getItem() {
        Block block = this.getBlock();
        IBlockState blockState = this.getBlockState();
        if (block == null || blockState == null || block == Blocks.field_150350_a || blockState.func_185904_a().func_76224_d()) {
            return null;
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(blockState);
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            return stack.func_77973_b();
        }
        return null;
    }

    @Nullable
    public Block getBlock() {
        IBlockState state = this.getBlockState();
        if (state == null) {
            return null;
        }
        return state.func_177230_c();
    }

    public boolean findNextBlock() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while (this.isStructureBlockEqualWorldBlock() && count < Configurations.gameplay.maxBlocksChecked);
        return true;
    }

    public boolean checkForFreeSpace(@NotNull BlockPos pos) {
        this.setLocalPosition(pos);
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    BlockPos localPos = new BlockPos(i, j, k);
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    if (worldPos.func_177956_o() <= pos.func_177956_o() && !this.world.func_180495_p(worldPos.func_177977_b()).func_185904_a().func_76220_a()) {
                        return false;
                    }
                    IBlockState worldState = this.world.func_180495_p(worldPos);
                    if (worldState.func_177230_c() == Blocks.field_150357_h) {
                        return false;
                    }
                    if (worldPos.func_177956_o() <= pos.func_177956_o() || worldState.func_177230_c() == Blocks.field_150350_a) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean decrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.func_181079_c(this.structure.getWidth(), this.structure.getHeight() - 1, this.structure.getLength() - 1);
        }
        this.progressPos.func_181079_c(this.progressPos.func_177958_n() - 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p());
        if (this.progressPos.func_177958_n() == -1) {
            this.progressPos.func_181079_c(this.structure.getWidth() - 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p() - 1);
            if (this.progressPos.func_177952_p() == -1) {
                this.progressPos.func_181079_c(this.progressPos.func_177958_n(), this.progressPos.func_177956_o() - 1, this.structure.getLength() - 1);
                if (this.progressPos.func_177956_o() == -1) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public int getHeight() {
        return this.structure.getHeight();
    }

    public int getWidth() {
        return this.structure.getWidth();
    }

    public int getLength() {
        return this.structure.getLength();
    }

    public StructureProxy getStructure() {
        return this.structure;
    }

    @Nullable
    public Template.BlockInfo getBlockInfo() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getBlockInfo((BlockPos)this.progressPos);
    }

    @Nullable
    public Template.EntityInfo getEntityinfo() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getEntityinfo((BlockPos)this.progressPos);
    }
}

