/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.util;

import com.structurize.api.util.LanguageHandler;
import com.structurize.api.util.Log;
import com.structurize.api.util.Utils;
import com.structurize.coremod.management.StructureName;
import com.structurize.structures.helpers.Settings;
import com.structurize.structures.helpers.Structure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public final class ClientStructureWrapper {
    private ClientStructureWrapper() {
    }

    public static void handleSaveScanMessage(NBTTagCompound nbttagcompound, String fileName) {
        StructureName structureName = new StructureName("scans", "new", fileName);
        File file = new File(Structure.getClientSchematicsFolders().get(0), structureName.toString() + ".nbt");
        Utils.checkDirectory(file.getParentFile());
        try (FileOutputStream outputstream = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)outputstream);
        }
        catch (IOException e) {
            LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "item.scepterSteel.scanFailure", new Object[0]);
            Log.getLogger().warn("Exception while trying to scan.", (Throwable)e);
            return;
        }
        LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "item.scepterSteel.scanSuccess", file);
        Settings.instance.setStructureName(structureName.toString());
    }

    public static void sendMessageSchematicTooBig(int maxSize) {
        LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "com.structurize.coremod.network.messages.schematicsavemessage.toobig", maxSize);
    }
}

