/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.tileentities;

import com.google.common.primitives.Ints;
import java.util.List;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class TileEntityMultiBlock
extends TileEntity
implements ITickable {
    private static final int MAX_RANGE = 10;
    private static final int MAX_SPEED = 3;
    private static final int MIN_SPEED = 1;
    public static final int DEFAULT_RANGE = 3;
    public static final int DEFAULT_SPEED = 2;
    private boolean on = false;
    private EnumFacing direction = EnumFacing.UP;
    private EnumFacing output = EnumFacing.DOWN;
    private int range = 3;
    private EnumFacing currentDirection;
    private int progress = 0;
    private int ticksPassed = 0;
    private int speed = 2;

    public void handleRedstone(boolean signal) {
        if (this.speed == 0) {
            this.speed = 2;
        }
        if (signal != this.on && this.progress == this.range) {
            this.on = signal;
            this.currentDirection = signal ? this.output : this.direction;
            this.progress = 0;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.currentDirection == null && this.progress < this.range) {
            this.progress = this.range;
        }
        if (this.progress < this.range) {
            if (this.ticksPassed % (20 / this.speed) == 0) {
                this.handleTick();
                this.ticksPassed = 1;
            }
            ++this.ticksPassed;
        }
    }

    public void handleTick() {
        EnumFacing currentOutPutDirection;
        EnumFacing enumFacing = currentOutPutDirection = this.currentDirection == this.direction ? this.output : this.direction;
        if (this.progress < this.range) {
            IBlockState blockToMove = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(this.currentDirection, 1));
            if (blockToMove.func_177230_c() == Blocks.field_150350_a || blockToMove.func_185905_o() == EnumPushReaction.IGNORE || blockToMove.func_185905_o() == EnumPushReaction.DESTROY || blockToMove.func_185905_o() == EnumPushReaction.BLOCK || blockToMove.func_177230_c().hasTileEntity(blockToMove) || blockToMove.func_177230_c() == Blocks.field_150357_h) {
                ++this.progress;
                return;
            }
            for (int i = 0; i < Math.min(this.range, 10); ++i) {
                BlockPos posToGoFrom;
                int blockToGoTo = i - 1 - this.progress + (i - 1 - this.progress >= 0 ? 1 : 0);
                int blockToGoFrom = i + 1 - this.progress - (i + 1 - this.progress <= 0 ? 1 : 0);
                BlockPos posToGo = blockToGoTo > 0 ? this.field_174879_c.func_177967_a(this.currentDirection, blockToGoTo) : this.field_174879_c.func_177967_a(currentOutPutDirection, Math.abs(blockToGoTo));
                BlockPos blockPos = posToGoFrom = blockToGoFrom > 0 ? this.field_174879_c.func_177967_a(this.currentDirection, blockToGoFrom) : this.field_174879_c.func_177967_a(currentOutPutDirection, Math.abs(blockToGoFrom));
                if (!this.field_145850_b.func_175623_d(posToGo)) continue;
                IBlockState tempState = this.field_145850_b.func_180495_p(posToGoFrom);
                if (blockToMove.func_177230_c() != tempState.func_177230_c() || !this.field_145850_b.func_175667_e(posToGoFrom) || !this.field_145850_b.func_175667_e(posToGo)) continue;
                this.pushEntitiesIfNecessary(posToGo, this.field_174879_c);
                this.field_145850_b.func_175656_a(posToGo, tempState);
                this.field_145850_b.func_175698_g(posToGoFrom);
            }
            this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, 0.8f);
            ++this.progress;
        }
    }

    private void pushEntitiesIfNecessary(BlockPos posToGo, BlockPos pos) {
        List entities = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(posToGo));
        BlockPos vector = posToGo.func_177973_b((Vec3i)pos);
        BlockPos posTo = posToGo.func_177972_a(EnumFacing.func_176737_a((float)vector.func_177958_n(), (float)vector.func_177956_o(), (float)vector.func_177952_p()));
        for (Entity entity : entities) {
            entity.func_70634_a((double)posTo.func_177958_n() + 0.5, (double)posTo.func_177956_o() + 0.5, (double)posTo.func_177952_p() + 0.5);
        }
    }

    public void func_189667_a(Rotation rotationIn) {
        if (this.output != EnumFacing.UP && this.output != EnumFacing.DOWN) {
            this.output = rotationIn.func_185831_a(this.output);
        }
        if (this.direction != EnumFacing.UP && this.direction != EnumFacing.DOWN) {
            this.direction = rotationIn.func_185831_a(this.direction);
        }
        super.func_189667_a(rotationIn);
    }

    public void func_189668_a(Mirror mirrorIn) {
        if (this.output != EnumFacing.UP && this.output != EnumFacing.DOWN) {
            this.output = mirrorIn.func_185803_b(this.output);
        }
        if (this.direction != EnumFacing.UP && this.direction != EnumFacing.DOWN) {
            this.direction = mirrorIn.func_185803_b(this.direction);
        }
        super.func_189668_a(mirrorIn);
    }

    public boolean isOn() {
        return this.on;
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public EnumFacing getOutput() {
        return this.output;
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
    }

    public void setOutput(EnumFacing output) {
        this.output = output;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = Math.min(range, 10);
        this.progress = range;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = Ints.constrainToRange((int)speed, (int)1, (int)3);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.range = compound.func_74762_e("range");
        this.progress = compound.func_74762_e("progress");
        this.direction = EnumFacing.values()[compound.func_74762_e("direction")];
        this.on = compound.func_74767_n("input");
        this.output = compound.func_74764_b("outputDirection") ? EnumFacing.values()[compound.func_74762_e("outputDirection")] : this.direction.func_176734_d();
        this.speed = compound.func_74762_e("speed");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("range", this.range);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("direction", this.direction.ordinal());
        compound.func_74757_a("input", this.on);
        if (this.output != null) {
            compound.func_74768_a("outputDirection", this.output.ordinal());
        }
        compound.func_74768_a("speed", this.speed);
        return compound;
    }

    protected void func_190201_b(World world) {
        this.func_145834_a(world);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
    }
}

