/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.placementhandlers;

import com.structurize.api.util.BlockUtils;
import com.structurize.coremod.blocks.schematic.BlockSolidSubstitution;
import com.structurize.coremod.placementhandlers.IPlacementHandler;
import com.structurize.coremod.placementhandlers.PlacementHandlers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopyPastePlacementHandlers {
    private CopyPastePlacementHandlers() {
    }

    public static void initHandlers() {
        PlacementHandlers.handlers.clear();
        PlacementHandlers.handlers.add(new PlacementHandlers.AirPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.FirePlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.GrassPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.DoorPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.BedPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.DoublePlantPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.SpecialBlockPlacementAttemptHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.FlowerPotPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.BlockGrassPathPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.StairBlockPlacementHandler());
        PlacementHandlers.handlers.add(new BlockSolidSubstitutionPlacementHandler());
        PlacementHandlers.handlers.add(new PlacementHandlers.GeneralBlockPlacementHandler());
    }

    public static class BlockSolidSubstitutionPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState) {
            return blockState.func_177230_c() instanceof BlockSolidSubstitution;
        }

        @Override
        public Object handle(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete, BlockPos centerPos) {
            IBlockState newBlockState = BlockUtils.getSubstitutionBlockAtWorld(world, pos);
            if (complete ? !world.func_180501_a(pos, blockState, 3) : !world.func_180501_a(pos, newBlockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return newBlockState;
        }

        @Override
        public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @Nullable NBTTagCompound tileEntityData, boolean complete) {
            IBlockState newBlockState = BlockUtils.getSubstitutionBlockAtWorld(world, pos);
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(newBlockState));
            return itemList;
        }
    }
}

