/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.network.messages;

import com.structurize.api.configuration.Configurations;
import com.structurize.coremod.management.Structures;
import com.structurize.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class StructurizeStylesMessage
extends AbstractMessage<StructurizeStylesMessage, IMessage> {
    private boolean allowPlayerSchematics;
    private Map<String, String> md5Map;

    public void fromBytes(@NotNull ByteBuf buf) {
        this.allowPlayerSchematics = buf.readBoolean();
        this.md5Map = StructurizeStylesMessage.readMD5MapFromByteBuf(buf);
    }

    @NotNull
    private static Map<String, String> readMD5MapFromByteBuf(@NotNull ByteBuf buf) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            String filename = ByteBufUtils.readUTF8String((ByteBuf)buf);
            String md5 = ByteBufUtils.readUTF8String((ByteBuf)buf);
            map.put(filename, md5);
        }
        return map;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeBoolean(Configurations.gameplay.allowPlayerSchematics);
        StructurizeStylesMessage.writeMD5MapToByteBuf(buf);
    }

    private static void writeMD5MapToByteBuf(@NotNull ByteBuf buf) {
        Map<String, String> md5s = Structures.getMD5s();
        buf.writeInt(md5s.size());
        for (Map.Entry<String, String> entry : md5s.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getValue());
        }
    }

    @Override
    protected void messageOnClientThread(StructurizeStylesMessage message, MessageContext ctx) {
        Structures.setAllowPlayerSchematics(message.allowPlayerSchematics);
        Structures.setMD5s(message.md5Map);
    }
}

