/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.network.messages;

import com.structurize.api.configuration.Configurations;
import com.structurize.api.util.Log;
import com.structurize.coremod.Structurize;
import com.structurize.coremod.management.Structures;
import com.structurize.coremod.network.messages.AbstractMessage;
import com.structurize.structures.helpers.Structure;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class SchematicSaveMessage
extends AbstractMessage<SchematicSaveMessage, IMessage> {
    private byte[] data = null;
    private int pieces;
    private int piece;
    private UUID id;

    public SchematicSaveMessage() {
    }

    public SchematicSaveMessage(byte[] data, UUID id, int pieces, int piece) {
        this.data = (byte[])data.clone();
        this.id = id;
        this.pieces = pieces;
        this.piece = piece;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        int length = buf.readInt();
        byte[] compressedData = new byte[length];
        buf.readBytes(compressedData);
        this.data = Structure.uncompress(compressedData);
        this.pieces = buf.readInt();
        this.piece = buf.readInt();
        this.id = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(@NotNull ByteBuf buf) {
        byte[] compressedData = Structure.compress(this.data);
        if (compressedData != null) {
            buf.capacity(compressedData.length + buf.writerIndex());
            buf.writeInt(compressedData.length);
            buf.writeBytes(compressedData);
            buf.writeInt(this.pieces);
            buf.writeInt(this.piece);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.id.toString());
        }
    }

    @Override
    public void messageOnServerThread(SchematicSaveMessage message, EntityPlayerMP player) {
        boolean schematicSent;
        if (!Structurize.isClient() && !Configurations.gameplay.allowPlayerSchematics) {
            Log.getLogger().info("SchematicSaveMessage: custom schematic is not allowed on this server.");
            player.func_145747_a((ITextComponent)new TextComponentString("The server does not allow custom schematic!"));
            return;
        }
        if (message.pieces > 20) {
            Log.getLogger().error("Schematic has more than 10 pieces, discarding.");
            player.func_145747_a((ITextComponent)new TextComponentString("Schematic has more than 10 pieces, that's too big!"));
            return;
        }
        if (message.data == null) {
            Log.getLogger().error("Received empty schematic file");
            schematicSent = false;
        } else {
            schematicSent = Structures.handleSaveSchematicMessage(message.data, message.id, message.pieces, message.piece);
        }
        if (schematicSent) {
            player.func_145747_a((ITextComponent)new TextComponentString("Schematic successfully sent!"));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("Failed to send the Schematic!"));
        }
    }

    @Override
    protected void messageOnClientThread(SchematicSaveMessage message, MessageContext ctx) {
        if (!Structurize.isClient() && !Configurations.gameplay.allowPlayerSchematics) {
            Log.getLogger().info("SchematicSaveMessage: custom schematic is not allowed on this server.");
        }
        if (message.data == null) {
            Log.getLogger().error("Received empty schematic file");
        } else {
            Structures.handleSaveSchematicMessage(message.data);
        }
    }
}

