/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.network.messages;

import com.structurize.api.util.BlockPosUtil;
import com.structurize.coremod.items.ItemScanTool;
import com.structurize.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ScanOnServerMessage
extends AbstractMessage<ScanOnServerMessage, IMessage> {
    private BlockPos from;
    private BlockPos to;
    private String name;

    public ScanOnServerMessage() {
    }

    public ScanOnServerMessage(@NotNull BlockPos from, @NotNull BlockPos to, @NotNull String name) {
        this.from = from;
        this.to = to;
        this.name = name;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.from = BlockPosUtil.readFromByteBuf(buf);
        this.to = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        BlockPosUtil.writeToByteBuf(buf, this.from);
        BlockPosUtil.writeToByteBuf(buf, this.to);
    }

    @Override
    public void messageOnServerThread(ScanOnServerMessage message, EntityPlayerMP player) {
        ItemScanTool.saveStructure(player.func_130014_f_(), message.from, message.to, (EntityPlayer)player, message.name);
    }
}

