/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.network.messages;

import com.structurize.api.util.Log;
import com.structurize.coremod.network.messages.AbstractMessage;
import com.structurize.coremod.util.ClientStructureWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class SaveScanMessage
extends AbstractMessage<SaveScanMessage, IMessage> {
    private static final String TAG_MILLIS = "millies";
    public static final String TAG_SCHEMATIC = "schematic";
    private NBTTagCompound nbttagcompound;
    private String fileName;

    public SaveScanMessage() {
    }

    public SaveScanMessage(NBTTagCompound nbttagcompound, String fileName) {
        this.fileName = fileName;
        this.nbttagcompound = nbttagcompound;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        try (ByteBufInputStream stream = new ByteBufInputStream((ByteBuf)buffer);){
            NBTTagCompound wrapperCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
            this.nbttagcompound = wrapperCompound.func_74775_l(TAG_SCHEMATIC);
            this.fileName = wrapperCompound.func_74779_i(TAG_MILLIS);
        }
        catch (RuntimeException e) {
            Log.getLogger().info("Structure too big to be processed", (Throwable)e);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
    }

    public void toBytes(@NotNull ByteBuf buf) {
        NBTTagCompound wrapperCompound = new NBTTagCompound();
        wrapperCompound.func_74778_a(TAG_MILLIS, this.fileName);
        wrapperCompound.func_74782_a(TAG_SCHEMATIC, (NBTBase)this.nbttagcompound);
        PacketBuffer buffer = new PacketBuffer(buf);
        try (ByteBufOutputStream stream = new ByteBufOutputStream((ByteBuf)buffer);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)wrapperCompound, (OutputStream)stream);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
    }

    @Override
    protected void messageOnClientThread(SaveScanMessage message, MessageContext ctx) {
        if (message.nbttagcompound != null) {
            ClientStructureWrapper.handleSaveScanMessage(message.nbttagcompound, message.fileName);
        }
    }
}

