/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.network.messages;

import com.structurize.api.util.BlockPosUtil;
import com.structurize.api.util.ChangeStorage;
import com.structurize.coremod.management.Manager;
import com.structurize.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class RemoveEntityMessage
extends AbstractMessage<RemoveEntityMessage, IMessage> {
    private BlockPos from;
    private BlockPos to;
    private String entityName;

    public RemoveEntityMessage() {
    }

    public RemoveEntityMessage(@NotNull BlockPos pos1, @NotNull BlockPos pos2, @NotNull String entityName) {
        this.from = pos1;
        this.to = pos2;
        this.entityName = entityName;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.from = BlockPosUtil.readFromByteBuf(buf);
        this.to = BlockPosUtil.readFromByteBuf(buf);
        this.entityName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.from);
        BlockPosUtil.writeToByteBuf(buf, this.to);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityName);
    }

    @Override
    public void messageOnServerThread(RemoveEntityMessage message, EntityPlayerMP player) {
        if (!player.field_71075_bZ.field_75098_d) {
            return;
        }
        WorldServer world = player.func_71121_q();
        ChangeStorage storage = new ChangeStorage((EntityPlayer)player);
        for (int x = Math.min(message.from.func_177958_n(), message.to.func_177958_n()); x <= Math.max(message.from.func_177958_n(), message.to.func_177958_n()); ++x) {
            for (int y = Math.min(message.from.func_177956_o(), message.to.func_177956_o()); y <= Math.max(message.from.func_177956_o(), message.to.func_177956_o()); ++y) {
                for (int z = Math.min(message.from.func_177952_p(), message.to.func_177952_p()); z <= Math.max(message.from.func_177952_p(), message.to.func_177952_p()); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    List list = world.func_72872_a(Entity.class, new AxisAlignedBB(here));
                    storage.addEntities(list);
                    for (Entity entity : list) {
                        if (!entity.func_70005_c_().equals(message.entityName)) continue;
                        entity.func_70106_y();
                    }
                }
            }
        }
        Manager.addToUndoCache(storage);
    }
}

