/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.network.messages;

import com.structurize.api.util.BlockPosUtil;
import com.structurize.coremod.management.Manager;
import com.structurize.coremod.network.messages.AbstractMessage;
import com.structurize.coremod.util.ScanToolOperation;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class RemoveBlockMessage
extends AbstractMessage<RemoveBlockMessage, IMessage> {
    private BlockPos from;
    private BlockPos to;
    private ItemStack block;

    public RemoveBlockMessage() {
    }

    public RemoveBlockMessage(@NotNull BlockPos pos1, @NotNull BlockPos pos2, @NotNull ItemStack stack) {
        this.from = pos1;
        this.to = pos2;
        this.block = stack;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.from = BlockPosUtil.readFromByteBuf(buf);
        this.to = BlockPosUtil.readFromByteBuf(buf);
        this.block = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.from);
        BlockPosUtil.writeToByteBuf(buf, this.to);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.block);
    }

    @Override
    public void messageOnServerThread(RemoveBlockMessage message, EntityPlayerMP player) {
        if (!player.field_71075_bZ.field_75098_d) {
            return;
        }
        Manager.addToQueue(new ScanToolOperation(ScanToolOperation.OperationType.REMOVE_BLOCK, message.from, message.to, (EntityPlayer)player, message.block, ItemStack.field_190927_a));
    }
}

