/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.network.messages;

import com.structurize.api.util.BlockPosUtil;
import com.structurize.coremod.network.messages.AbstractMessage;
import com.structurize.coremod.tileentities.TileEntityMultiBlock;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class MultiBlockChangeMessage
extends AbstractMessage<MultiBlockChangeMessage, IMessage> {
    private EnumFacing direction;
    private EnumFacing output;
    private int range;
    private int speed;
    private BlockPos pos;

    public MultiBlockChangeMessage() {
    }

    public MultiBlockChangeMessage(BlockPos pos, EnumFacing facing, EnumFacing output, int range, int speed) {
        this.pos = pos;
        this.direction = facing;
        this.range = range;
        this.output = output;
        this.speed = speed;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.pos = BlockPosUtil.readFromByteBuf(buf);
        this.direction = EnumFacing.values()[buf.readInt()];
        this.output = EnumFacing.values()[buf.readInt()];
        this.range = buf.readInt();
        this.speed = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.pos);
        buf.writeInt(this.direction.ordinal());
        buf.writeInt(this.output.ordinal());
        buf.writeInt(this.range);
        buf.writeInt(this.speed);
    }

    @Override
    public void messageOnServerThread(MultiBlockChangeMessage message, EntityPlayerMP player) {
        TileEntity entity = player.func_71121_q().func_175625_s(message.pos);
        if (entity instanceof TileEntityMultiBlock) {
            ((TileEntityMultiBlock)entity).setDirection(message.direction);
            ((TileEntityMultiBlock)entity).setOutput(message.output);
            ((TileEntityMultiBlock)entity).setRange(message.range);
            ((TileEntityMultiBlock)entity).setSpeed(message.speed);
            IBlockState state = player.func_71121_q().func_180495_p(message.pos);
            player.func_71121_q().func_184138_a(message.pos, state, state, 3);
        }
    }
}

