/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.network.messages;

import com.structurize.api.util.BlockPosUtil;
import com.structurize.api.util.Shape;
import com.structurize.coremod.management.Manager;
import com.structurize.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class GenerateAndPasteMessage
extends AbstractMessage<GenerateAndPasteMessage, IMessage> {
    private boolean hollow;
    private ItemStack block;
    private ItemStack block2;
    private Shape shape;
    private BlockPos pos;
    private int length;
    private int width;
    private int height;
    private int frequency;
    private int rotation;
    private boolean mirror;

    public GenerateAndPasteMessage() {
    }

    public GenerateAndPasteMessage(@NotNull BlockPos pos, int length, int width, int height, int frequency, Shape shape, ItemStack block, ItemStack block2, boolean hollow, int rotation, Mirror mirror) {
        this.pos = pos;
        this.length = length;
        this.width = width;
        this.height = height;
        this.frequency = frequency;
        this.shape = shape;
        this.block = block;
        this.block2 = block2;
        this.hollow = hollow;
        this.mirror = mirror != Mirror.NONE;
        this.rotation = rotation;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.pos = BlockPosUtil.readFromByteBuf(buf);
        this.length = buf.readInt();
        this.width = buf.readInt();
        this.height = buf.readInt();
        this.frequency = buf.readInt();
        this.shape = Shape.values()[buf.readInt()];
        this.block = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.block2 = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.hollow = buf.readBoolean();
        this.rotation = buf.readInt();
        this.mirror = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.pos);
        buf.writeInt(this.length);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
        buf.writeInt(this.frequency);
        buf.writeInt(this.shape.ordinal());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.block);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.block2);
        buf.writeBoolean(this.hollow);
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.mirror);
    }

    @Override
    public void messageOnServerThread(GenerateAndPasteMessage message, EntityPlayerMP player) {
        if (!player.field_71075_bZ.field_75098_d) {
            return;
        }
        Manager.pasteStructure(player.func_71121_q(), message.pos, message.width, message.length, message.height, message.frequency, message.shape, message.block, message.block2, message.hollow, player, message.mirror ? Mirror.FRONT_BACK : Mirror.NONE, message.rotation);
    }
}

