/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.network.messages;

import com.structurize.coremod.client.gui.WindowBuildTool;
import com.structurize.coremod.management.StructureName;
import com.structurize.coremod.management.Structures;
import com.structurize.coremod.network.messages.AbstractMessage;
import com.structurize.coremod.util.StructureWrapper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildToolPasteMessage
extends AbstractMessage<BuildToolPasteMessage, IMessage> {
    private boolean complete;
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;

    public BuildToolPasteMessage() {
    }

    public BuildToolPasteMessage(String structureName, String workOrderName, BlockPos pos, int rotation, boolean isHut, Mirror mirror, boolean complete, WindowBuildTool.FreeMode freeMode) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.complete = complete;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.structureName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.workOrderName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
        this.complete = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.structureName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.workOrderName);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
        buf.writeBoolean(this.complete);
    }

    @Override
    public void messageOnServerThread(BuildToolPasteMessage message, EntityPlayerMP player) {
        StructureName sn = new StructureName(message.structureName);
        if (!Structures.hasMD5(sn)) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can not build " + message.workOrderName + ": schematic missing!"));
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            StructureWrapper.loadAndPlaceStructureWithRotation(player.field_70170_p, message.structureName, message.pos, message.rotation, message.mirror ? Mirror.FRONT_BACK : Mirror.NONE, message.complete, player);
        }
    }
}

