/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.management;

import com.structurize.api.configuration.Configurations;
import com.structurize.api.util.BlockUtils;
import com.structurize.api.util.ChangeStorage;
import com.structurize.api.util.Log;
import com.structurize.api.util.Shape;
import com.structurize.coremod.management.UUIDStorage;
import com.structurize.coremod.util.ScanToolOperation;
import com.structurize.coremod.util.StructureWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class Manager {
    private static boolean schematicDownloaded = false;
    private static LinkedList<ChangeStorage> changeQueue = new LinkedList();
    private static LinkedList<ScanToolOperation> scanToolOperationPool = new LinkedList();
    private static volatile UUID serverUUID = null;

    private Manager() {
    }

    public static void onWorldTick(WorldServer world) {
        ScanToolOperation operation;
        if (!scanToolOperationPool.isEmpty() && (operation = scanToolOperationPool.peek()) != null && operation.apply(world)) {
            scanToolOperationPool.pop();
            if (!operation.isUndo()) {
                Manager.addToUndoCache(operation.getChangeStorage());
            }
        }
    }

    public static void addToQueue(ScanToolOperation operation) {
        scanToolOperationPool.push(operation);
    }

    public static void addToUndoCache(ChangeStorage storage) {
        if (changeQueue.size() >= Configurations.gameplay.maxCachedChanges) {
            changeQueue.pop();
        }
        changeQueue.push(storage);
    }

    public static void pasteStructure(WorldServer server, BlockPos pos, int width, int length, int height, int frequency, Shape shape, ItemStack inputBlock, ItemStack inputFillBlock, boolean hollow, EntityPlayerMP player, Mirror mirror, int rotation) {
        Template template = Manager.getStructureFromFormula(width, length, height, frequency, shape, inputBlock, inputFillBlock, hollow);
        StructureWrapper.loadAndPlaceShapeWithRotation(server, template, pos, rotation, mirror, player);
    }

    public static Template getStructureFromFormula(int width, int length, int height, int frequency, Shape shape, ItemStack inputBlock, ItemStack inputFillBlock, boolean hollow) {
        Template template = new Template();
        IBlockState mainBlock = BlockUtils.getBlockStateFromStack(inputBlock);
        IBlockState fillBlock = BlockUtils.getBlockStateFromStack(inputFillBlock);
        if (shape == Shape.SPHERE || shape == Shape.HALF_SPHERE || shape == Shape.BOWL) {
            Manager.generateSphere(template, height / 2, mainBlock, fillBlock, hollow, shape);
        } else if (shape == Shape.CUBE) {
            Manager.generateCube(template, height, width, length, mainBlock, fillBlock, hollow);
        } else if (shape == Shape.WAVE) {
            Manager.generateWave(template, height, width, length, frequency, mainBlock, true);
        } else if (shape == Shape.WAVE_3D) {
            Manager.generateWave(template, height, width, length, frequency, mainBlock, false);
        } else if (shape == Shape.CYLINDER) {
            Manager.generateCylinder(template, height, width, mainBlock, fillBlock, hollow);
        } else if (shape == Shape.DIAMOND || shape == Shape.PYRAMID || shape == Shape.UPSIDE_DOWN_PYRAMID) {
            Manager.generatePyramid(template, height, mainBlock, fillBlock, hollow, shape);
        }
        return template;
    }

    private static void generatePyramid(Template template, int inputHeight, IBlockState block, IBlockState fillBlock, boolean hollow, Shape shape) {
        int height = shape == Shape.DIAMOND ? inputHeight : inputHeight * 2;
        HashMap<BlockPos, IBlockState> posList = new HashMap<BlockPos, IBlockState>();
        for (int y = 0; y < height / 2; ++y) {
            for (int x = 0; x < height / 2; ++x) {
                for (int z = 0; z < height / 2; ++z) {
                    IBlockState blockToUse;
                    if (!(x == z && x >= y || x == y && x >= z) && (!(hollow ? y == z : y >= z) || y < x) || x * z > y * y) continue;
                    IBlockState iBlockState = blockToUse = x == z && x >= y || x == y || y == z ? block : fillBlock;
                    if (shape == Shape.UPSIDE_DOWN_PYRAMID || shape == Shape.DIAMOND) {
                        Manager.addPosToList(new BlockPos(x, y, z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(x, y, -z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(-x, y, z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(-x, y, -z), blockToUse, posList);
                    }
                    if (shape != Shape.PYRAMID && shape != Shape.DIAMOND) continue;
                    Manager.addPosToList(new BlockPos(x, -y + height - 2, z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(x, -y + height - 2, -z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(-x, -y + height - 2, z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(-x, -y + height - 2, -z), blockToUse, posList);
                }
            }
        }
        template.field_186272_c = new BlockPos(height, height, height);
        template.field_186270_a.addAll(posList.entrySet().stream().map(pos -> new Template.BlockInfo((BlockPos)pos.getKey(), (IBlockState)pos.getValue(), null)).collect(Collectors.toList()));
    }

    private static void generateCube(Template template, int height, int width, int length, IBlockState block, IBlockState fillBlock, boolean hollow) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    if (hollow && x != 0 && x != width - 1 && y != 0 && y != height - 1 && z != 0 && z != length - 1) continue;
                    IBlockState blockToUse = x == 0 || x == width - 1 || y == 0 || y == height - 1 || z == 0 || z == length - 1 ? block : fillBlock;
                    template.field_186270_a.add(new Template.BlockInfo(new BlockPos(x, y, z), blockToUse, null));
                }
            }
        }
        template.field_186272_c = new BlockPos(width, height, length);
    }

    private static void generateSphere(Template template, int height, IBlockState block, IBlockState fillBlock, boolean hollow, Shape shape) {
        HashMap<BlockPos, IBlockState> posList = new HashMap<BlockPos, IBlockState>();
        for (int y = 0; y <= height + 1; ++y) {
            for (int x = 0; x <= height + 1; ++x) {
                for (int z = 0; z <= height + 1; ++z) {
                    IBlockState blockToUse;
                    int sum = x * x + z * z + y * y;
                    if (sum >= height * height || hollow && sum <= height * height - 2 * height) continue;
                    IBlockState iBlockState = blockToUse = sum > height * height - 2 * height ? block : fillBlock;
                    if (shape == Shape.HALF_SPHERE || shape == Shape.SPHERE) {
                        Manager.addPosToList(new BlockPos(x, y, z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(x, y, -z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(-x, y, z), blockToUse, posList);
                        Manager.addPosToList(new BlockPos(-x, y, -z), blockToUse, posList);
                    }
                    if (shape != Shape.BOWL && shape != Shape.SPHERE) continue;
                    Manager.addPosToList(new BlockPos(x, -y, z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(x, -y, -z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(-x, -y, z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(-x, -y, -z), blockToUse, posList);
                }
            }
        }
        template.field_186272_c = new BlockPos(height * 2, height * 2, height * 2);
        template.field_186270_a.addAll(posList.entrySet().stream().map(pos -> new Template.BlockInfo((BlockPos)pos.getKey(), (IBlockState)pos.getValue(), null)).collect(Collectors.toList()));
    }

    private static void generateCylinder(Template template, int height, int width, IBlockState block, IBlockState fillBlock, boolean hollow) {
        HashMap<BlockPos, IBlockState> posList = new HashMap<BlockPos, IBlockState>();
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                for (int y = 0; y < height; ++y) {
                    int sum = x * x + z * z;
                    if (sum >= width * width / 4 || hollow && sum <= width * width / 4 - width) continue;
                    IBlockState blockToUse = sum > width * width / 4 - width ? block : fillBlock;
                    Manager.addPosToList(new BlockPos(x, y, z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(x, y, -z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(-x, y, z), blockToUse, posList);
                    Manager.addPosToList(new BlockPos(-x, y, -z), blockToUse, posList);
                }
            }
        }
        template.field_186272_c = new BlockPos(width, height, width);
        template.field_186270_a.addAll(posList.entrySet().stream().map(pos -> new Template.BlockInfo((BlockPos)pos.getKey(), (IBlockState)pos.getValue(), null)).collect(Collectors.toList()));
    }

    private static void generateWave(Template template, int height, int width, int length, int frequency, IBlockState block, boolean flat) {
        HashMap<BlockPos, IBlockState> posList = new HashMap<BlockPos, IBlockState>();
        for (int x = 0; x < length; ++x) {
            for (int z = 0; z < width; ++z) {
                double yVal = (double)(flat ? 0 : z) + (double)frequency * Math.sin((double)x / (double)height);
                Manager.addPosToList(new BlockPos((double)x, yVal, (double)z), block, posList);
                if (flat) continue;
                Manager.addPosToList(new BlockPos((double)x, yVal, (double)(-z)), block, posList);
                Manager.addPosToList(new BlockPos((double)x, yVal + (double)width - 1.0, (double)(z - width + 1)), block, posList);
                Manager.addPosToList(new BlockPos((double)x, yVal + (double)width - 1.0, (double)(-z + width - 1)), block, posList);
            }
        }
        template.field_186272_c = new BlockPos(length, height * length + 1, width * 2 + 1);
        template.field_186270_a.addAll(posList.entrySet().stream().map(pos -> new Template.BlockInfo((BlockPos)pos.getKey(), (IBlockState)pos.getValue(), null)).collect(Collectors.toList()));
    }

    public static void generateRandomShape(Template template, int height, int width, int length) {
        double radiusX = 20.0;
        double radiusY = 26.0;
        double radiusZ = 5.0;
        ArrayList posList = new ArrayList();
        for (double x = 0.0; x <= 20.0; x += 1.0) {
            for (double y = 0.0; y <= 26.0; y += 1.0) {
                for (double z = 0.0; z <= 5.0; z += 1.0) {
                }
            }
        }
        template.field_186270_a.addAll(posList.stream().map(pos -> new Template.BlockInfo((BlockPos)pos.func_76341_a(), (IBlockState)pos.func_76340_b(), null)).collect(Collectors.toList()));
    }

    private static void addPosToList(BlockPos blockPos, IBlockState blockToUse, Map<BlockPos, IBlockState> posList) {
        if (!posList.containsKey(blockPos)) {
            posList.put(blockPos, blockToUse);
        }
    }

    public static void undo(EntityPlayer player) {
        Iterable iterable = () -> changeQueue.iterator();
        Stream<ChangeStorage> storageStream = StreamSupport.stream(iterable.spliterator(), false);
        Optional<ChangeStorage> theStorage = storageStream.filter(storage -> storage.isOwner(player)).findFirst();
        if (theStorage.isPresent()) {
            Manager.addToQueue(new ScanToolOperation(theStorage.get(), player));
            changeQueue.remove(theStorage.get());
        }
    }

    public static UUID getServerUUID() {
        if (serverUUID == null) {
            return Manager.generateOrRetrieveUUID();
        }
        return serverUUID;
    }

    private static UUID generateOrRetrieveUUID() {
        MapStorage storage = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T();
        UUIDStorage instance = (UUIDStorage)storage.func_75742_a(UUIDStorage.class, "structurize_UUID");
        if (instance == null) {
            if (serverUUID == null) {
                Manager.setServerUUID(UUID.randomUUID());
                Log.getLogger().info(String.format("New Server UUID %s", serverUUID));
            }
            storage.func_75745_a("structurize_UUID", (WorldSavedData)new UUIDStorage());
        }
        return serverUUID;
    }

    public static void setServerUUID(UUID uuid) {
        serverUUID = uuid;
    }

    public static boolean isSchematicDownloaded() {
        return schematicDownloaded;
    }

    public static void setSchematicDownloaded(boolean downloaded) {
        schematicDownloaded = downloaded;
    }
}

