/*
 * Decompiled with CFR 0.152.
 */
package com.structurize.coremod.client.gui;

import com.structurize.blockout.controls.Button;
import com.structurize.blockout.controls.ButtonHandler;
import com.structurize.blockout.controls.TextField;
import com.structurize.blockout.views.Window;
import com.structurize.coremod.Structurize;
import com.structurize.coremod.management.StructureName;
import com.structurize.coremod.management.Structures;
import com.structurize.structures.helpers.Settings;
import org.jetbrains.annotations.NotNull;

public class WindowStructureNameEntry
extends Window
implements ButtonHandler {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String INPUT_NAME = "name";
    private static final String STRUCTURE_NAME_RESOURCE_SUFFIX = ":gui/windowstructurenameentry.xml";
    private final StructureName structureName;
    private final TextField inputName;

    public WindowStructureNameEntry(StructureName s) {
        super("structurize:gui/windowstructurenameentry.xml");
        this.structureName = s;
        this.inputName = this.findPaneOfTypeByID(INPUT_NAME, TextField.class);
    }

    @Override
    public void onOpened() {
        this.inputName.setText(this.structureName.getStyle() + '/' + this.structureName.getSchematic());
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals(BUTTON_DONE)) {
            StructureName newStructureName;
            String name = this.inputName.getText();
            if (!name.isEmpty() && (newStructureName = Structures.renameScannedStructure(this.structureName, name)) != null) {
                Settings.instance.setStructureName(newStructureName.toString());
            }
        } else if (!button.getID().equals(BUTTON_CANCEL)) {
            return;
        }
        this.close();
        Structurize.proxy.openBuildToolWindow(null);
    }
}

